/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/
#include <drmcommon.h>
#include <drmlicense.h>

/* Define all constants here.  If we put it in an include file we will have multiple defines when linking */
#ifdef WMDRM_ON_SEP
/* Only these 2 constant are needed on the SEP side */
/* The version for client id. */
const DRM_BYTE              CLIENT_ID_VER [__CB_DECL(VERSION_LEN)]      =
{
	TWO_BYTES(2, 0), TWO_BYTES(0, 0)
}; 

const PUBKEY g_pubkeyLicenseServer = 
{
	{
		TWO_BYTES(0x52, 0xF5), TWO_BYTES(0x5A, 0x8A), TWO_BYTES(0x8A, 0x7F), TWO_BYTES(0xEA, 0x57), 
			TWO_BYTES(0x55, 0x24), TWO_BYTES(0x93, 0xA9), TWO_BYTES(0x8C, 0x11), TWO_BYTES(0x06, 0x58), 
			TWO_BYTES(0x37, 0xAD), TWO_BYTES(0x9F, 0x66), TWO_BYTES(0x68, 0xC1), TWO_BYTES(0x1C, 0x16), 
			TWO_BYTES(0x2D, 0x4A), TWO_BYTES(0x57, 0xBA), TWO_BYTES(0x7B, 0x6C), TWO_BYTES(0xA4, 0x24), 
			TWO_BYTES(0x14, 0x2B), TWO_BYTES(0x4E, 0x2E), TWO_BYTES(0x89, 0xF1), TWO_BYTES(0x39, 0x4E) 
	}
};

#else /* WMDRM_ON_SEP */

const PUBKEY g_pubkeyLicenseServer = 
{
    {
         TWO_BYTES(0x52, 0xF5), TWO_BYTES(0x5A, 0x8A), TWO_BYTES(0x8A, 0x7F), TWO_BYTES(0xEA, 0x57), 
         TWO_BYTES(0x55, 0x24), TWO_BYTES(0x93, 0xA9), TWO_BYTES(0x8C, 0x11), TWO_BYTES(0x06, 0x58), 
         TWO_BYTES(0x37, 0xAD), TWO_BYTES(0x9F, 0x66), TWO_BYTES(0x68, 0xC1), TWO_BYTES(0x1C, 0x16), 
         TWO_BYTES(0x2D, 0x4A), TWO_BYTES(0x57, 0xBA), TWO_BYTES(0x7B, 0x6C), TWO_BYTES(0xA4, 0x24), 
         TWO_BYTES(0x14, 0x2B), TWO_BYTES(0x4E, 0x2E), TWO_BYTES(0x89, 0xF1), TWO_BYTES(0x39, 0x4E) 
    }
};

/* Some of these must be kept in sync with what is in license.h */
const DRM_LID g_rgbSecStoreGlobalName =
{
	{TWO_BYTES('g', 'l'),  TWO_BYTES('o', 'b'),  TWO_BYTES('a', 'l'),  
	 TWO_BYTES('.', 's'),  TWO_BYTES('e', 'c'),  TWO_BYTES('s', 't'),  
	 TWO_BYTES('a', 't'),  TWO_BYTES('e', '\0')}
};

#if DRM_SUPPORT_REVOCATION
const DRM_LID g_lidRevocationInfo =
{
    TWO_BYTES('R', 'E'),  TWO_BYTES('V', 'O'),  TWO_BYTES('C', 'A'),
    TWO_BYTES('T', 'I'),  TWO_BYTES('O', 'N'),  TWO_BYTES('I', 'N'),
    TWO_BYTES('F', 'O'),  TWO_BYTES('\0', '\0')
};
#if DRM_SUPPORT_DEVICE_REVOCATION
/* DeviceRevocation */
const DRM_LID g_lidDeviceRevocation =
{
    TWO_BYTES('D', 'e'),  TWO_BYTES('v', 'i'),  TWO_BYTES('c', 'e'),
    TWO_BYTES('R', 'e'),  TWO_BYTES('v', 'o'),  TWO_BYTES('c', 'a'),
    TWO_BYTES('t', 'i'),  TWO_BYTES('o', 'n')
};
#endif               

#if DRM_SUPPORT_WMDRMNET
/* WMDRMNET_RVK */
const DRM_LID g_lidWMDRMNET_Revocation =
{
    TWO_BYTES('W', 'M'),   TWO_BYTES('D', 'R'),  TWO_BYTES('M', 'N'),
    TWO_BYTES('E', 'T'),   TWO_BYTES('_', 'R'),  TWO_BYTES('V', 'K'),
    TWO_BYTES('\0', '\0'), TWO_BYTES('\0', '\0')
};
#endif

#if DRM_SUPPORT_APP_REVOCATION
/* RevocationList */
const DRM_LID g_lidAppRevocation =
{
    TWO_BYTES('R', 'e'),  TWO_BYTES('v', 'o'),  TWO_BYTES('c', 'a'),
    TWO_BYTES('t', 'i'),  TWO_BYTES('o', 'n'),  TWO_BYTES('L', 'i'),
    TWO_BYTES('s', 't'),  TWO_BYTES('\0', '\0')
};
#endif /* DRM_SUPPORT_APP_REVOCATION */
#endif

/* DRM Version. Keep this in sync with DRM_VERSION_STRING above. */
const DRM_WCHAR             g_rgwchDRM_VERSION_STRING                  []= { ONE_WCHAR('2', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_CONST_STRING      g_dstrDRM_VERSION_STRING                     = CREATE_DRM_STRING( g_rgwchDRM_VERSION_STRING );

const DRM_BYTE              DRM_VERSION [__CB_DECL(VERSION_LEN)]         =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
}; 

/* Indicates the version of the pubkey to be used for verification of PK CERT. */
const DRM_BYTE              PK_VER [__CB_DECL(VERSION_LEN)]              =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
}; 

/* Version of the key file. */
const DRM_BYTE              KEYFILE_VER [__CB_DECL(VERSION_LEN)]         =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
}; 


const DRM_BYTE              LICREQUEST_VER [__CB_DECL(VERSION_LEN)]    =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
};

/* Indicates the public root key needed to verify the license server certificates. */
const DRM_BYTE              CERT_VER [__CB_DECL(VERSION_LEN)]          =
{
    TWO_BYTES(0, 1), TWO_BYTES(0, 0)
};

/* Indicates the license version delivered. */
const DRM_BYTE              LICENSE_VER [__CB_DECL(VERSION_LEN)]       =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
}; 

/* The version for client id. */
const DRM_BYTE              CLIENT_ID_VER [__CB_DECL(VERSION_LEN)]      =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
}; 

/* Content Version. Keep this in sync with CONTENT_VERSION_STRING above. */
const DRM_BYTE              CONTENT_VERSION [__CB_DECL(VERSION_LEN)]    =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
}; 



/* v1 rights bits */
const DRM_BYTE              RIGHT_PLAY_ON_PC [__CB_DECL(RIGHTS_LEN)]     =
{
    TWO_BYTES(1, 0), TWO_BYTES(0, 0)
};
const DRM_BYTE              RIGHT_COPY_TO_NONSDMI_DEVICE [__CB_DECL(RIGHTS_LEN)]    =
{
    TWO_BYTES(2, 0), TWO_BYTES(0, 0)
};
const DRM_BYTE              RIGHT_NO_RESTORE [__CB_DECL(RIGHTS_LEN)]                =
{
    TWO_BYTES(4, 0), TWO_BYTES(0, 0)
};
const DRM_BYTE              RIGHT_BURN_TO_CD [__CB_DECL(RIGHTS_LEN)]                =
{
    TWO_BYTES(8, 0), TWO_BYTES(0, 0)
};
const DRM_BYTE              RIGHT_COPY_TO_SDMI_DEVICE [__CB_DECL(RIGHTS_LEN)]       =
{
    TWO_BYTES(0x10, 0), TWO_BYTES(0, 0)
};
const DRM_BYTE              RIGHT_ONE_TIME [__CB_DECL(RIGHTS_LEN)]                  =
{
    TWO_BYTES(0x20, 0), TWO_BYTES(0, 0)
};

/* Character constants */
#ifdef __unix__
const DRM_WCHAR             g_wchPathSeperator                          = WCHAR_CAST('/');
#else
const DRM_WCHAR             g_wchPathSeperator                          = WCHAR_CAST('\\');
#endif
const DRM_WCHAR             g_wchNull                                   = WCHAR_CAST('\0');
const DRM_WCHAR             g_wchMinus                                  = WCHAR_CAST('-');
const DRM_WCHAR             g_wchPlus                                   = WCHAR_CAST('+');
const DRM_WCHAR             g_wchForwardSlash                           = WCHAR_CAST('/');
const DRM_WCHAR             g_wchColon                                  = WCHAR_CAST(':');
const DRM_WCHAR             g_wchComma                                  = WCHAR_CAST(',');
const DRM_WCHAR             g_wchQuote                                  = WCHAR_CAST('\"');
const DRM_WCHAR             g_wchSingleQuote                            = WCHAR_CAST('\'');
const DRM_WCHAR             g_wchNewLine                                = WCHAR_CAST('\n');
const DRM_WCHAR             g_wchBackSlash                              = WCHAR_CAST('\\');
const DRM_WCHAR             g_wch0                                      = WCHAR_CAST('0');
const DRM_WCHAR             g_wch1                                      = WCHAR_CAST('1');
const DRM_WCHAR             g_wch2                                      = WCHAR_CAST('2');
const DRM_WCHAR             g_wch9                                      = WCHAR_CAST('9');
const DRM_WCHAR             g_wcha                                      = WCHAR_CAST('a');
const DRM_WCHAR             g_wchd                                      = WCHAR_CAST('d');
const DRM_WCHAR             g_wchf                                      = WCHAR_CAST('f');
const DRM_WCHAR             g_wchh                                      = WCHAR_CAST('h');
const DRM_WCHAR             g_wchm                                      = WCHAR_CAST('m');
const DRM_WCHAR             g_wchn                                      = WCHAR_CAST('n');
const DRM_WCHAR             g_wchs                                      = WCHAR_CAST('s');
const DRM_WCHAR             g_wchy                                      = WCHAR_CAST('y');
const DRM_WCHAR             g_wchA                                      = WCHAR_CAST('A');
const DRM_WCHAR             g_wchF                                      = WCHAR_CAST('F');
const DRM_WCHAR             g_wchx                                      = WCHAR_CAST('x');
const DRM_WCHAR             g_wchX                                      = WCHAR_CAST('X');
const DRM_WCHAR             g_wchUnderscore                             = WCHAR_CAST('_');
const DRM_WCHAR             g_wchz                                      = WCHAR_CAST('z');
const DRM_WCHAR             g_wchZ                                      = WCHAR_CAST('Z');
const DRM_WCHAR             g_wchPeriod                                 = WCHAR_CAST('.');
const DRM_WCHAR             g_wchQuestionMark                           = WCHAR_CAST('?');
const DRM_WCHAR             g_wchExclamationMark                        = WCHAR_CAST('!');
const DRM_WCHAR             g_wchOpenParen                              = WCHAR_CAST('(');
const DRM_WCHAR             g_wchCloseParen                             = WCHAR_CAST(')');
const DRM_WCHAR             g_wchPound                                  = WCHAR_CAST('#');
const DRM_WCHAR             g_wchSpace                                  = WCHAR_CAST(' ');
const DRM_WCHAR             g_wchTab                                    = WCHAR_CAST('\x9');
const DRM_WCHAR             g_wchLineFeed                               = WCHAR_CAST('\xA');
const DRM_WCHAR             g_wchVerticalTab                            = WCHAR_CAST('\xB');
const DRM_WCHAR             g_wchFormFeed                               = WCHAR_CAST('\xC');
const DRM_WCHAR             g_wchCarriageReturn                         = WCHAR_CAST('\xD');
const DRM_WCHAR             g_wchEqual                                  = WCHAR_CAST('=');
const DRM_WCHAR             g_wchOpenCurly                              = WCHAR_CAST('{');
const DRM_WCHAR             g_wchCloseCurly                             = WCHAR_CAST('}');
const DRM_WCHAR             g_wchLessThan                               = WCHAR_CAST('<');
const DRM_WCHAR             g_wchGreaterThan                            = WCHAR_CAST('>');
const DRM_WCHAR             g_wchLeftBracket                            = WCHAR_CAST('[');
const DRM_WCHAR             g_wchRightBracket                           = WCHAR_CAST(']');
const DRM_WCHAR             g_wchAsterisk                               = WCHAR_CAST('*');
const DRM_WCHAR             g_wchPercent                                = WCHAR_CAST('%');
const DRM_WCHAR             g_wchSemiColon                              = WCHAR_CAST(';');
const DRM_WCHAR             g_wchAmpersand                              = WCHAR_CAST('&');
const DRM_WCHAR             g_wchPipe                                   = WCHAR_CAST('|');



const DRM_WCHAR      g_rgwchWMDRM_RIGHT_PLAYBACK                  [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_COLLABORATIVE_PLAY        [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_COPY_TO_CD                [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('k', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_COPY                      [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_CREATE_THUMBNAIL_IMAGE    [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0') };  //{ ONE_WCHAR('C', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};

#if DRM_SUPPORT_PMLICENSE
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_COPY_TO_SDMI_DEVICE       [] =  { ONE_WCHAR('T', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('f', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_COPY_TO_NON_SDMI_DEVICE   [] =  { ONE_WCHAR('T', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('f', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('\0', '\0')};
#endif

#if DRM_BACKUP_RESTORE_SUPPORT
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_BACKUP                    [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('k', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('\0', '\0')};
#endif

#if DRM_SUPPORT_PLAYLIST_BURN
const DRM_WCHAR      g_rgwchPlaylistBurnCount                     [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchWMDRM_RIGHT_PLAYLIST_BURN             [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
#endif



/* String constants */
const DRM_CHAR       g_rgchAttributeVersion                       [] =  { TWO_BYTES('v', 'e'),  TWO_BYTES('r', 's'),  TWO_BYTES('i', 'o'),  TWO_BYTES('n', '\0'),  TWO_BYTES('\0', '\0')};         /* ODD count */
const DRM_CHAR       g_rgchAttributeEncrypted                     [] =  { TWO_BYTES('e', 'n'),  TWO_BYTES('c', 'r'),  TWO_BYTES('y', 'p'),  TWO_BYTES('t', 'e'),  TWO_BYTES('d', '\0'),  TWO_BYTES('\0', '\0')};       /* ODD count */
const DRM_CHAR       g_rgchLicVerAttrValue                        [] =  { TWO_BYTES('2', '.'),  TWO_BYTES('0', '.'),  TWO_BYTES('0', '.'),  TWO_BYTES('0', '\0'),  TWO_BYTES('\0', '\0')};         /* ODD count */
const DRM_CHAR       g_rgchLicenseTag                             [] =  { TWO_BYTES('L', 'I'),  TWO_BYTES('C', 'E'),  TWO_BYTES('N', 'S'),  TWO_BYTES('E', '\0'),  TWO_BYTES('\0', '\0')};         /* ODD count */
const DRM_CHAR       g_rgchLicenseRespTag                         [] =  { TWO_BYTES('L', 'I'),  TWO_BYTES('C', 'E'),  TWO_BYTES('N', 'S'),  TWO_BYTES('E', 'R'),  TWO_BYTES('E', 'S'),  TWO_BYTES('P', 'O'),  TWO_BYTES('N', 'S'),  TWO_BYTES('E', '\0'),  TWO_BYTES('\0', '\0')}; /* ODD count */
const DRM_CHAR       g_rgchAttributeFALSE                         [] =  { TWO_BYTES('F', 'A'),  TWO_BYTES('L', 'S'),  TWO_BYTES('E', '\0'),  TWO_BYTES('\0', '\0')};           /* ODD count */

const DRM_WCHAR      g_rgwchAttributeVersion                      [] =  { ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAttributeEncrypted                    [] =  { ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLicVerAttrValue                       [] =  { ONE_WCHAR('2', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLicenseRespTag                        [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLicenseTag                            [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAttributeFALSE                        [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};

/* Script varibles used for license properties. */
const DRM_WCHAR      g_rgwchDRM_LS_BEGIN_ATTR                     [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_COUNT_ATTR                     [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchDRM_LS_BEGDATE_ATTR                   [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_ENDDATE_ATTR                   [] =  { ONE_WCHAR('E', '\0'),  ONE_WCHAR('x', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_FIRSTUSE_ATTR                  [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_EXPIRATION_AFTER_FIRSTUSE_ATTR [] =  { ONE_WCHAR('H', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_MINAPPSECLEVEL_ATTR            [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_APPSEC_ATTR                    [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_BURNTOCDCOUNT_ATTR             [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_TRANSFERCOUNT_ATTR             [] =  { ONE_WCHAR('T', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('f', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_PLAYCOUNT_ATTR                 [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_BEGINBURNTOCDCOUNT_ATTR        [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_BEGINTRANSFERCOUNT_ATTR        [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('f', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_BEGINPLAYCOUNT_ATTR            [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchDRM_LS_DELETED_ATTR                   [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0') };  //{ ONE_WCHAR('d', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};

#if DRM_SUPPORT_ANTIROLLBACK_CLOCK
const DRM_WCHAR      g_rgwchDRM_LS_OLDSAVETIME_ATTR               [] =  { ONE_WCHAR('O', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0') }; //  { ONE_WCHAR('O', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_MACHINE_DATETIME               [] =  { ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0') }; // { ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
#endif

const DRM_WCHAR      g_rgwchDRM_LS_MACHINE_DATETIME_GE            [] =  { ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('>', '\0'),  ONE_WCHAR('=', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('#', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_MACHINE_DATETIME_LE            [] =  { ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('<', '\0'),  ONE_WCHAR('=', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('#', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRM_LS_APP_MINSECLEVEL_GE             [] =  { ONE_WCHAR('a', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('>', '\0'),  ONE_WCHAR('=', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchEqual                                 [] =  { ONE_WCHAR('=', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchDrmRestoreInfo                        [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagData                               [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagLID                                [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchTagIndex                              [] =  { ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagEnablingbits                       [] =  { ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSymValue                           [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSymSig                             [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchTagHashAlgorithm                      [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagPubkey                             [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagValue                              [] =  { ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSignature                          [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagHashAlg                            [] =  { ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSignAlg                            [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSHA                                   [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchMSDRM                                 [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchMSDRM_CK                              [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchAttributeType                          [] =  { TWO_BYTES('t', 'y'),   TWO_BYTES('p', 'e'),   TWO_BYTES('\0', '\0')};
const DRM_WCHAR      g_rgwchAttributeType                         [] =  { ONE_WCHAR('t', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSavedDateTime                         [] =  { ONE_WCHAR('g', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};

#if DRM_SUPPORT_ANTIROLLBACK_CLOCK
const DRM_WCHAR      g_rgwchCheckClockRollback                    [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('>', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchResetRollbackedClock                  [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('=', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
#endif

const DRM_WCHAR      g_rgwchSetSavedDateTime                      [] =  { ONE_WCHAR('(', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('>', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(')', '\0'),  ONE_WCHAR('?', '\0'),  ONE_WCHAR('(', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('=', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR(')', '\0'),  ONE_WCHAR(':', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR(';', '\0'),  ONE_WCHAR('1', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCreatePMLicense                       [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchVersion_1_0                           [] =  { ONE_WCHAR('1', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagDevinfo                            [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagFallback                           [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchTagError                              [] =  { ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathSigValue                         [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagDataInclusionList                  [] =  { ONE_WCHAR('L', '\0'), ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),   ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),   ONE_WCHAR('O', '\0'), ONE_WCHAR('R', '\0'),   ONE_WCHAR('I', '\0'), ONE_WCHAR('N', '\0'),   ONE_WCHAR('F', '\0'), ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'), ONE_WCHAR('D', '\0'),   ONE_WCHAR('A', '\0'), ONE_WCHAR('T', '\0'),   ONE_WCHAR('A', '\0'), ONE_WCHAR('/', '\0'),   ONE_WCHAR('I', '\0'), ONE_WCHAR('N', '\0'),   ONE_WCHAR('C', '\0'), ONE_WCHAR('L', '\0'),   ONE_WCHAR('U', '\0'), ONE_WCHAR('S', '\0'),   ONE_WCHAR('I', '\0'), ONE_WCHAR('O', '\0'),   ONE_WCHAR('N', '\0'), ONE_WCHAR('L', '\0'),   ONE_WCHAR('I', '\0'), ONE_WCHAR('S', '\0'),   ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0') };
const DRM_WCHAR      g_rgwchFeatureIndivURL                       [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCompatCert                            [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCompatSecVersion                      [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSubjectId                             [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchMaxSecLevel                           [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAuthSecVer                            [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAuthPubKey                            [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathTagSignature                     [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSignatureVal                       [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathTagCertificateChain              [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAuthData                              [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAuthHashAlg                           [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAuthSignAlg                           [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchFallback                              [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};


const DRM_WCHAR      g_rgwchXPathTagSecurityLevel                 [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchXPathTagCertificate                   [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathDataUniqueID                     [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Q', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchXPathManufacturer                     [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathMake                             [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathModel                            [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathDistributor                      [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathHardwareMajor                    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('J', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathHardwareMinor                    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathFirmwareMajor                    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('J', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathFirmwareMinor                    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathFeatureTemplate                  [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathClientOldKeys                    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathClientEscrowKeys                 [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathClientEscrowKey                  [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathIndivServerEscrowKey             [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathDevicePublicKey                  [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathOldKeysData                      [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathIndivSvrPubKey                   [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathSecureClock                      [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathIndivType                        [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathSecureStore                      [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathMetering                         [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathLicenseChain                     [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};


const DRM_WCHAR      g_rgwchTagDevCert                            [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagWrmHeader                          [] =  { ONE_WCHAR('W', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAttributeVersionValue                 [] =  { ONE_WCHAR('2', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagLAINFO                             [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagKID                                [] =  { ONE_WCHAR('K', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagChecksum                           [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathHeaderUplinks                    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagUplink                             [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagUplinks                            [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchTagLicenseRequest                     [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Q', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagAction                             [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchTagV1Challenge                        [] =  { ONE_WCHAR('V', '\0'),  ONE_WCHAR('1', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDefaultV1Data                         [] =  { ONE_WCHAR('N', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagActionList                         [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSecurityVersion                    [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};

/*
**  Devcert Non-indiv Tags
*/
const DRM_WCHAR      g_rgwchTagDNIUniqueID        [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Q', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagMSDRMSignature     [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchPrivateKeys           [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCertTypeDevice        [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCerttypeGroup         [] =  { ONE_WCHAR('G', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCerttypeAuth          [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCerttypeAuthRoot      [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};

/*
**  Devcert Non-indiv XPaths
*/






const DRM_WCHAR      g_rgwchXPathPubkeyData         [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCSecureClock      [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCSecureClockURL   [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCSecureClockPubKey[] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCMetering         [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCLicenseAcquisitionMode[] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('Q', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCLicenseSyncMode  [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCSymmOpts         [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCEncryption       [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCMaxChainDepth    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCMaxLicenseSize   [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathGCMaxHeaderSize    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathDeviceKeydata      [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathDACAuthID          [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};



const DRM_WCHAR      g_rgwchReqTagClientInfo                      [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagClientID                        [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagClientVersion                   [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagAppSecurity                     [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagSubjectID1                      [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('J', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('1', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagSubjectID2                      [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('J', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('2', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagDrmkVersion                     [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagClientVersionData               [] =  { ONE_WCHAR('9', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('2', '\0'),  ONE_WCHAR('7', '\0'),  ONE_WCHAR('7', '\0'),  ONE_WCHAR('8', '\0'),  ONE_WCHAR('\0', '\0')}; /* BUGBUG */
const DRM_WCHAR      g_rgwchReqTagSubjectID2Data                  [] =  { ONE_WCHAR(' ', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReqTagDrmkData                        [] =  { ONE_WCHAR(' ', '\0'),  ONE_WCHAR('\0', '\0')};

/* Xml tags used in parsing licenses */
const DRM_WCHAR      g_rgwchLicense                               [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchGUID                                  [] =  { ONE_WCHAR('G', '\0'), ONE_WCHAR('U', '\0'), ONE_WCHAR('I', '\0'), ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0') };
const DRM_WCHAR      g_rgwchLicensorInfoNode                      [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLIData                                [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchMeta                                  [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_CHAR       g_rgchTagRevocation                          [] =  { TWO_BYTES('R', 'E'),  TWO_BYTES('V', 'O'),  TWO_BYTES('C', 'A'),  TWO_BYTES('T', 'I'),  TWO_BYTES('O', 'N'),  TWO_BYTES('\0', '\0')};
const DRM_WCHAR      g_rgwchTagRevocation                         [] =  { ONE_WCHAR('R', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('V', '\0'), ONE_WCHAR('O', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('T', '\0'), ONE_WCHAR('I', '\0'), ONE_WCHAR('O', '\0'), ONE_WCHAR('N', '\0'), ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchTagRevocationInfo                      [] =  { TWO_BYTES('R', 'E'),  TWO_BYTES('V', 'O'),  TWO_BYTES('C', 'A'),  TWO_BYTES('T', 'I'),  TWO_BYTES('O', 'N'),  TWO_BYTES('I', 'N'),  TWO_BYTES('F', 'O'),  TWO_BYTES('\0', '\0')};
const DRM_WCHAR      g_rgwchTagRevocationInfo                     [] =  { ONE_WCHAR('R', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('V', '\0'), ONE_WCHAR('O', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('T', '\0'), ONE_WCHAR('I', '\0'), ONE_WCHAR('O', '\0'), ONE_WCHAR('N', '\0'), ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAppRevocation                         [] =  { ONE_WCHAR('R', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('v', '\0'), ONE_WCHAR('o', '\0'), ONE_WCHAR('c', '\0'), ONE_WCHAR('a', '\0'), ONE_WCHAR('t', '\0'), ONE_WCHAR('i', '\0'), ONE_WCHAR('o', '\0'), ONE_WCHAR('n', '\0'), ONE_WCHAR('L', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDeviceRevocation                      [] =  { ONE_WCHAR('D', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('v', '\0'), ONE_WCHAR('i', '\0'), ONE_WCHAR('c', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('R', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('v', '\0'), ONE_WCHAR('o', '\0'), ONE_WCHAR('c', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchDeviceRevocation                       [] =  { TWO_BYTES('D', 'e'),  TWO_BYTES('v', 'i'),  TWO_BYTES('c', 'e'),  TWO_BYTES('R', 'e'),  TWO_BYTES('v', 'o'),  TWO_BYTES('c', 'a'),  TWO_BYTES('t', 'i'),  TWO_BYTES('o', 'n'),  TWO_BYTES('L', 'i'),  TWO_BYTES('s', 't'),  TWO_BYTES('\0', '\0')}; /* ODD count */
const DRM_WCHAR      g_rgwchDeviceRevocationList                  [] =  { ONE_WCHAR('D', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('v', '\0'), ONE_WCHAR('i', '\0'), ONE_WCHAR('c', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('R', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('v', '\0'), ONE_WCHAR('o', '\0'), ONE_WCHAR('c', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchWMDRMNET_Revocation                   [] =  { ONE_WCHAR('W', '\0'), ONE_WCHAR('M', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('R', '\0'), ONE_WCHAR('M', '\0'), ONE_WCHAR('N', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('T', '\0'), ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchWMDRMNET_Revocation                    [] =  { TWO_BYTES('W', 'M'),  TWO_BYTES('D', 'R'),  TWO_BYTES('M', 'N'),  TWO_BYTES('E', 'T'),  TWO_BYTES('\0', '\0')};
const DRM_CHAR       g_rgchTagSLK                                 [] =  { TWO_BYTES('S', 'L'),  TWO_BYTES('K', '\0'), TWO_BYTES('\0', '\0')};
const DRM_CHAR       g_rgchTagSLKID                               [] =  { TWO_BYTES('S', 'L'),  TWO_BYTES('K', 'I'),  TWO_BYTES('D', '\0'), TWO_BYTES('\0', '\0')};
const DRM_CHAR       g_rgchTagSLKDATA                             [] =  { TWO_BYTES('S', 'L'),  TWO_BYTES('K', 'D'),  TWO_BYTES('A', 'T'),  TWO_BYTES('A', '\0'),  TWO_BYTES('\0', '\0')};
const DRM_WCHAR      g_rgwchTagRevInfoVersion                     [] =  { ONE_WCHAR('R', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('V', '\0'), ONE_WCHAR('I', '\0'), ONE_WCHAR('N', '\0'), ONE_WCHAR('F', '\0'), ONE_WCHAR('O', '\0'), ONE_WCHAR('V', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('R', '\0'), ONE_WCHAR('S', '\0'), ONE_WCHAR('I', '\0'), ONE_WCHAR('O', '\0'), ONE_WCHAR('N', '\0'), ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchTagRevInfoVersion                      [] =  { TWO_BYTES('R', 'E'),  TWO_BYTES('V', 'I'),  TWO_BYTES('N', 'F'),  TWO_BYTES('O', 'V'),  TWO_BYTES('E', 'R'),  TWO_BYTES('S', 'I'),  TWO_BYTES('O', 'N'),  TWO_BYTES('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSourceID                           [] =  { ONE_WCHAR('S', '\0'), ONE_WCHAR('O', '\0'), ONE_WCHAR('U', '\0'), ONE_WCHAR('R', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('I', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchTagSourceID                            [] =  { TWO_BYTES('S', 'O'),  TWO_BYTES('U', 'R'),  TWO_BYTES('C', 'E'),  TWO_BYTES('I', 'D'),  TWO_BYTES('\0', '\0')};
const DRM_WCHAR      g_rgwchInclusionList                       [] = { ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};


#if DRM_SUPPORT_REVOCATION
    
#if DRM_SUPPORT_WMDRMNET
/* {CD75E604-543D-4A9C-9F09-FE6D24E8BF90} */
const DRM_WCHAR      g_rgwchRevocationGuidWMDRMNET                [] = { ONE_WCHAR('{', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('7', '\0'), ONE_WCHAR('5', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('6', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('5', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('F', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('F', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('6', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('2', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('8', '\0'), ONE_WCHAR('B', '\0'), ONE_WCHAR('F', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('}', '\0'), };

/* {CD75E604-543D-4A9C-9F09-FE6D24E8BF90} */
const DRM_CHAR       g_rgchRevocationGuidWMDRMNET                 [] = { TWO_BYTES('{', 'C'), TWO_BYTES('D', '7'), TWO_BYTES('5', 'E'), TWO_BYTES('6', '0'), TWO_BYTES('4', '-'), TWO_BYTES('5', '4'), TWO_BYTES('3', 'D'), TWO_BYTES('-', '4'), TWO_BYTES('A', '9'), TWO_BYTES('C', '-'), TWO_BYTES('9', 'F'), TWO_BYTES('0', '9'), TWO_BYTES('-', 'F'), TWO_BYTES('E', '6'), TWO_BYTES('D', '2'), TWO_BYTES('4', 'E'), TWO_BYTES('8', 'B'), TWO_BYTES('F', '9'), TWO_BYTES('0', '}'), };
#endif /* DRM_SUPPORT_WMDRMNET */

#if DRM_SUPPORT_DEVICE_REVOCATION
/* {3129E375-CEB0-47D5-9CCA-9DB74CFD4332} */
const DRM_WCHAR      g_rgwchRevocationGuidDevice                  [] = { ONE_WCHAR('{', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('1', '\0'), ONE_WCHAR('2', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('7', '\0'), ONE_WCHAR('5', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('B', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('7', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('5', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('B', '\0'), ONE_WCHAR('7', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('F', '\0'), ONE_WCHAR('D', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('2', '\0'), ONE_WCHAR('}', '\0'), };

/* {3129E375-CEB0-47D5-9CCA-9DB74CFD4332} */
const DRM_CHAR       g_rgchRevocationGuidDevice                   [] = { TWO_BYTES('{', '3'), TWO_BYTES('1', '2'), TWO_BYTES('9', 'E'), TWO_BYTES('3', '7'), TWO_BYTES('5', '-'), TWO_BYTES('C', 'E'), TWO_BYTES('B', '0'), TWO_BYTES('-', '4'), TWO_BYTES('7', 'D'), TWO_BYTES('5', '-'), TWO_BYTES('9', 'C'), TWO_BYTES('C', 'A'), TWO_BYTES('-', '9'), TWO_BYTES('D', 'B'), TWO_BYTES('7', '4'), TWO_BYTES('C', 'F'), TWO_BYTES('D', '4'), TWO_BYTES('3', '3'), TWO_BYTES('2', '}'), };
#endif /* DRM_SUPPORT_DEVICE_REVOCATION */

#if DRM_SUPPORT_APP_REVOCATION
/* {90A37313-0ECF-4CAA-A906-B188F6129300} */
const DRM_WCHAR      g_rgwchRevocationGuidApp                     [] = { ONE_WCHAR('{', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('7', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('1', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('E', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('F', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('4', '\0'), ONE_WCHAR('C', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('A', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('6', '\0'), ONE_WCHAR('-', '\0'), ONE_WCHAR('B', '\0'), ONE_WCHAR('1', '\0'), ONE_WCHAR('8', '\0'), ONE_WCHAR('8', '\0'), ONE_WCHAR('F', '\0'), ONE_WCHAR('6', '\0'), ONE_WCHAR('1', '\0'), ONE_WCHAR('2', '\0'), ONE_WCHAR('9', '\0'), ONE_WCHAR('3', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('0', '\0'), ONE_WCHAR('}', '\0'), };

/* {90A37313-0ECF-4CAA-A906-B188F6129300} */
const DRM_CHAR       g_rgchRevocationGuidApp                      [] = { TWO_BYTES('{', '9'), TWO_BYTES('0', 'A'), TWO_BYTES('3', '7'), TWO_BYTES('3', '1'), TWO_BYTES('3', '-'), TWO_BYTES('0', 'E'), TWO_BYTES('C', 'F'), TWO_BYTES('-', '4'), TWO_BYTES('C', 'A'), TWO_BYTES('A', '-'), TWO_BYTES('A', '9'), TWO_BYTES('0', '6'), TWO_BYTES('-', 'B'), TWO_BYTES('1', '8'), TWO_BYTES('8', 'F'), TWO_BYTES('6', '1'), TWO_BYTES('2', '9'), TWO_BYTES('3', '0'), TWO_BYTES('0', '}'), };
#endif /* DRM_SUPPORT APP_REVOCATION */

#endif /* DRM_SUPPORT_REVOCATION */

const DRM_WCHAR       g_rgwchTagSLK                               [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR       g_rgwchTagSLKID                             [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR       g_rgwchTagSLKDATA                           [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchDeviceRevocationLicenseTag            [] =  { ONE_WCHAR('d', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('v', '\0'), ONE_WCHAR('i', '\0'), ONE_WCHAR('c', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('\0', '\0') };
const DRM_WCHAR      g_rgwchWMDRMNETRevocationLicenseTag          [] =  { ONE_WCHAR('w', '\0'), ONE_WCHAR('m', '\0'), ONE_WCHAR('d', '\0'), ONE_WCHAR('r', '\0'), ONE_WCHAR('m', '\0'), ONE_WCHAR('n', '\0'), ONE_WCHAR('e', '\0'), ONE_WCHAR('t', '\0') };

const DRM_WCHAR      g_rgwchMeteringId                            [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchPriority                              [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchIssueDate                             [] =  { ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchContentPubKey                         [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchContentRevocation                     [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCondition                             [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAction                                [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchRestrictions                          [] =  { ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchChainedEnablingBits                   [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDrmRestoreInfoEnablingBits            [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCertChain                             [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagCertificate                        [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLISigHashAlgo                         [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLISigAlgo                             [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLISigValue                            [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchOnActionPath                          [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathSymSig                           [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathSymValue                         [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchSequenceNumber                        [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Q', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLSPubKey                              [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchUplinkKid                             [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchChainedCheckSum                       [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchPMLicenseVersionString                [] =  { ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('1', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchPMLicenseVersionString                 [] =   { TWO_BYTES('0', '.'),  TWO_BYTES('1', '.'),  TWO_BYTES('0', '.'),  TWO_BYTES('0', '\0'),  TWO_BYTES('\0', '\0')}; /* ODD count */
const DRM_WCHAR      g_rgwchRevAttribute                          [] =  { ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDerivedLicTemplate                    [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLicDataDerivedTmpl                    [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};


/* XML tags used in writing Challenge and parsing Response for metering */
const DRM_WCHAR      g_rgwchTagMetering                           [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagHash                               [] =  { ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchXPathMID                              [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};                      
const DRM_WCHAR      g_rgwchTagMID                                [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};                      
const DRM_WCHAR      g_rgwchTagTID                                [] =  { ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagCmd                                [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagPassword                           [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagRecords                            [] =  { ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagURL                                [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagPartialData                        [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLabelValue                            [] =  { ONE_WCHAR('v', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchHMAC                                  [] =  { ONE_WCHAR('H', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchChallenge                             [] =  { ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwch1                                     [] =  { ONE_WCHAR('1', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchReset                                 [] =  { ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_CHAR       g_rgchTagMeterCert                           [] =  { TWO_BYTES('M', 'E'),  TWO_BYTES('T', 'E'),  TWO_BYTES('R', 'C'),  TWO_BYTES('E', 'R'),  TWO_BYTES('T', '\0'),  TWO_BYTES('\0', '\0')}; /* ODD count */

const DRM_WCHAR      g_rgwchTagMeterCert                          [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchTagCertificateChain                   [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};

/* tags used for sync lists */
const DRM_WCHAR      g_rgwchTagPrivateKey                         [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagDevice                             [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchKeyDataTag                            [] =  { ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchGroupTag                              [] =  { ONE_WCHAR('G', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('\0', '\0')};

const DRM_WCHAR      g_rgwchTagSyncList                           [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
                                                                                                          
const DRM_WCHAR      g_rgwchBackup                                [] =  { ONE_WCHAR('B', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('k', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchRestore                               [] =  { ONE_WCHAR('R', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchRootSigValueVersionTag                [] =  { ONE_WCHAR('p', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchRootSigValueVersionVal                [] =  { ONE_WCHAR('1', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchPFRootTag                             [] =  { ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDACPubKeyTag                          [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAuthRoot                              [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagNameValue                          [] =  { ONE_WCHAR('W', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('f', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR(' ', '\0'),  ONE_WCHAR('2', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('3', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('1', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('1', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('0', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagSecurityLevel                      [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagDataId                             [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagDataPubKey                         [] =  { ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchFallBack                              [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagName                               [] =  { ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchManufacturer                          [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchModel                                 [] =  { ONE_WCHAR('M', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchHwMajor                               [] =  { ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('J', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchHwMinor                               [] =  { ONE_WCHAR('H', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchFwMajor                               [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('J', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchFwMinor                               [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchFeatures                              [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSecClockNotSet                        [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSecClockSet                           [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSecClockNeedsRefresh                  [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTemplate                              [] =  { ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchIndivPubKey                           [] =  { ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('_', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchUniqueId                              [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('Q', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchUnsignedtemplate                      [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};

/* This data is used explicitly in the gen tools */
const DRM_WCHAR      g_rgwchTagDataSecVer                         [] =  { ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};

/* Strings for the expression evaluator functions */
const DRM_WCHAR      g_rgwchExprFuncDateAdd                       [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprFuncDateDiff                      [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('f', '\0'),  ONE_WCHAR('f', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprFuncMin                           [] =  { ONE_WCHAR('m', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprFuncMax                           [] =  { ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('x', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprFuncDatePart                      [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprFuncVersionCompare                [] =  { ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprFuncDeleteLicense                 [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprFuncExists                        [] =  { ONE_WCHAR('e', '\0'),  ONE_WCHAR('x', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('\0', '\0')};

/* Strings for license evaluator well known actions */
const DRM_WCHAR      g_rgwchLicEvalOnSelect                       [] =  { ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLicEvalOnDelete                       [] =  { ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLicEvalOnStore                        [] =  { ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLicEvalOnAction                       [] =  { ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
#if DRM_SUPPORT_ANTIROLLBACK_CLOCK 
const DRM_WCHAR      g_rgwchLicEvalOnClockRollback                [] =  { ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
#endif

/* Strings for expression evaluator variable evaluation */
const DRM_WCHAR      g_rgwchDRM_PREFIX                            [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDRMK_PREFIX                           [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('k', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchMACHINE_PREFIX                        [] =  { ONE_WCHAR('m', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchAPP_PREFIX                            [] =  { ONE_WCHAR('a', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSECSTATE_PREFIX                       [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLICENSE_PREFIX                        [] =  { ONE_WCHAR('l', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCONTENT_PREFIX                        [] =  { ONE_WCHAR('c', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchDEVICE_PREFIX                         [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchPMLICENSE_PREFIX                      [] =  { ONE_WCHAR('p', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSECURETIME_PREFIX                     [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchPLAYLISTBURN_PREFIX                   [] =  { ONE_WCHAR('p', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};

#if DRM_SUPPORT_SST_REDUNANCY
const DRM_WCHAR      g_rgwchSSTREDUNDANCY_PREFIX                  [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
#endif

const DRM_WCHAR      g_rgwchExprVarVersion                        [] =  { ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarParameter                      [] =  { ONE_WCHAR('p', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarReason                         [] =  { ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarBBMSDRMVersion                 [] =  { ONE_WCHAR('b', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarDateTime                       [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarCount                          [] =  { ONE_WCHAR('c', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarMinSecLevel                    [] =  { ONE_WCHAR('m', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarSecLevel                       [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarAppSecLevel                    [] =  { ONE_WCHAR('a', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarSubjID                         [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('j', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarAppSubjID                      [] =  { ONE_WCHAR('a', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('j', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarGlobal                         [] =  { ONE_WCHAR('g', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('b', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('.', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarSaveDateTime                   [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarSavedDateTime                  [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarDRMReason                      [] =  { ONE_WCHAR('d', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarRights                         [] =  { ONE_WCHAR('r', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarExpiryDate                     [] =  { ONE_WCHAR('e', '\0'),  ONE_WCHAR('x', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarInGracePeriod                  [] =  { ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarGpStartTime                    [] =  { ONE_WCHAR('g', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarIncrementCount                 [] =  { ONE_WCHAR('i', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('m', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchExprVarDevReg                         [] =  { ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};

/* XML tags */
const DRM_WCHAR      g_rgwchTagCDATA                              [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagCDATAOpenBracket                   [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('[', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_CHAR       g_rgchTagCDATAOpenBracket                    [] =   { TWO_BYTES('C', 'D'),  TWO_BYTES('A', 'T'),  TWO_BYTES('A', '['),  TWO_BYTES('\0', '\0')};
const DRM_WCHAR      g_rgwchOpenTag                               [] =  { ONE_WCHAR('<', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchSpace                                 [] =  { ONE_WCHAR(' ', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchOpenEndTag                            [] =  { ONE_WCHAR('<', '\0'),  ONE_WCHAR('/', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCloseTag                              [] =  { ONE_WCHAR('>', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchEqualQuote                            [] =  { ONE_WCHAR('=', '\0'),  ONE_WCHAR('\"', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchQuote                                 [] =  { ONE_WCHAR('\"', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchOpenCDATATag                          [] =  { ONE_WCHAR('<', '\0'),  ONE_WCHAR('!', '\0'),  ONE_WCHAR('[', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('[', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchCloseCDATATag                         [] =  { ONE_WCHAR(']', '\0'),  ONE_WCHAR(']', '\0'),  ONE_WCHAR('>', '\0'),  ONE_WCHAR('\0', '\0')};


const DRM_CHAR  g_rgchAttributeAlgorithm        [] = { TWO_BYTES('A', 'l'), TWO_BYTES('g', 'o'), TWO_BYTES('r', 'i'), TWO_BYTES('t', 'h'), TWO_BYTES('m', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchAttributeAlgorithm_LEN 9
const DRM_CHAR  g_rgchAttributeVersionWMDRM     [] = { TWO_BYTES('c', ':'), TWO_BYTES('V', 'e'), TWO_BYTES('r', 's'), TWO_BYTES('i', 'o'), TWO_BYTES('n', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchAttributeVersionWMDRM_LEN 9
const DRM_CHAR  g_rgchTagEscrowedKeys           [] = { TWO_BYTES('E', 's'), TWO_BYTES('c', 'r'), TWO_BYTES('o', 'w'), TWO_BYTES('e', 'd'), TWO_BYTES('K', 'e'), TWO_BYTES('y', 's'), TWO_BYTES('\0', '\0') };
#define g_rgchTagEscrowedKeys_LEN 12
const DRM_CHAR  g_rgchKeyUsageSignCert          [] = { TWO_BYTES('c', ':'), TWO_BYTES('S', 'i'), TWO_BYTES('g', 'n'), TWO_BYTES('C', 'e'), TWO_BYTES('r', 't'), TWO_BYTES('i', 'f'), TWO_BYTES('i', 'c'), TWO_BYTES('a', 't'), TWO_BYTES('e', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchKeyUsageSignCert_LEN 17
const DRM_CHAR  g_rgchKeyUsageSignCRL           [] = { TWO_BYTES('c', ':'), TWO_BYTES('S', 'i'), TWO_BYTES('g', 'n'), TWO_BYTES('C', 'R'), TWO_BYTES('L', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchKeyUsageSignCRL_LEN 9
const DRM_CHAR  g_rgchKeyUsageEncryptKey        [] = { TWO_BYTES('c', ':'), TWO_BYTES('E', 'n'), TWO_BYTES('c', 'r'), TWO_BYTES('y', 'p'), TWO_BYTES('t', 'K'), TWO_BYTES('e', 'y'), TWO_BYTES('\0', '\0') };
#define g_rgchKeyUsageEncryptKey_LEN 12
const DRM_CHAR  g_rgchOne                       [] = { TWO_BYTES('1', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchOne_LEN 1
const DRM_CHAR  g_rgchPrefixManufacturer        [] = { TWO_BYTES('x', 'm'), TWO_BYTES('l', 'n'), TWO_BYTES('s', ':'), TWO_BYTES('f', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchPrefixManufacturer_LEN 7
const DRM_CHAR  g_rgchTagCanonicalization       [] = { TWO_BYTES('C', 'a'), TWO_BYTES('n', 'o'), TWO_BYTES('n', 'i'), TWO_BYTES('c', 'a'), TWO_BYTES('l', 'i'), TWO_BYTES('z', 'a'), TWO_BYTES('t', 'i'), TWO_BYTES('o', 'n'), TWO_BYTES('M', 'e'), TWO_BYTES('t', 'h'), TWO_BYTES('o', 'd'), TWO_BYTES('\0', '\0') };
#define g_rgchTagCanonicalization_LEN 22
const DRM_CHAR  g_rgchTagCertificateCollection  [] = { TWO_BYTES('c', ':'), TWO_BYTES('C', 'e'), TWO_BYTES('r', 't'), TWO_BYTES('i', 'f'), TWO_BYTES('i', 'c'), TWO_BYTES('a', 't'), TWO_BYTES('e', 'C'), TWO_BYTES('o', 'l'), TWO_BYTES('l', 'e'), TWO_BYTES('c', 't'), TWO_BYTES('i', 'o'), TWO_BYTES('n', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagCertificateCollection_LEN 23
const DRM_CHAR  g_rgchTagDigestMethod           [] = { TWO_BYTES('D', 'i'), TWO_BYTES('g', 'e'), TWO_BYTES('s', 't'), TWO_BYTES('M', 'e'), TWO_BYTES('t', 'h'), TWO_BYTES('o', 'd'), TWO_BYTES('\0', '\0') };
#define g_rgchTagDigestMethod_LEN 12
const DRM_CHAR  g_rgchURIDSigSHA1               [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 'w'), TWO_BYTES('w', 'w'), TWO_BYTES('.', 'w'), TWO_BYTES('3', '.'), TWO_BYTES('o', 'r'), TWO_BYTES('g', '/'), TWO_BYTES('2', '0'), TWO_BYTES('0', '0'), TWO_BYTES('/', '0'), TWO_BYTES('9', '/'), TWO_BYTES('x', 'm'), TWO_BYTES('l', 'd'), TWO_BYTES('s', 'i'), TWO_BYTES('g', '#'), TWO_BYTES('s', 'h'), TWO_BYTES('a', '1'), TWO_BYTES('\0', '\0') };
#define g_rgchURIDSigSHA1_LEN 38
const DRM_CHAR  g_rgchTagDigestValue            [] = { TWO_BYTES('D', 'i'), TWO_BYTES('g', 'e'), TWO_BYTES('s', 't'), TWO_BYTES('V', 'a'), TWO_BYTES('l', 'u'), TWO_BYTES('e', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagDigestValue_LEN 11
const DRM_CHAR  g_rgchTagSignatureValue         [] = { TWO_BYTES('S', 'i'), TWO_BYTES('g', 'n'), TWO_BYTES('a', 't'), TWO_BYTES('u', 'r'), TWO_BYTES('e', 'V'), TWO_BYTES('a', 'l'), TWO_BYTES('u', 'e'), TWO_BYTES('\0', '\0') };
#define g_rgchTagSignatureValue_LEN 14
const DRM_CHAR  g_rgchTagKeyInfo                [] = { TWO_BYTES('K', 'e'), TWO_BYTES('y', 'I'), TWO_BYTES('n', 'f'), TWO_BYTES('o', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagKeyInfo_LEN 7
const DRM_CHAR  g_rgchTagSymmetricKey           [] = { TWO_BYTES('S', 'y'), TWO_BYTES('m', 'm'), TWO_BYTES('K', 'e'), TWO_BYTES('y', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagSymmetricKey_LEN 7
const DRM_CHAR  g_rgchTagPublicKey              [] = { TWO_BYTES('P', 'u'), TWO_BYTES('b', 'l'), TWO_BYTES('i', 'c'), TWO_BYTES('K', 'e'), TWO_BYTES('y', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagPublicKey_LEN 9
const DRM_CHAR  g_rgchTagPrivateKey             [] = { TWO_BYTES('P', 'r'), TWO_BYTES('i', 'v'), TWO_BYTES('a', 't'), TWO_BYTES('e', 'K'), TWO_BYTES('e', 'y'), TWO_BYTES('\0', '\0') };
#define g_rgchTagPrivateKey_LEN 10
const DRM_CHAR  g_rgchTagKeyValue               [] = { TWO_BYTES('K', 'e'), TWO_BYTES('y', 'V'), TWO_BYTES('a', 'l'), TWO_BYTES('u', 'e'), TWO_BYTES('\0', '\0') };
#define g_rgchTagKeyValue_LEN 8
const DRM_CHAR  g_rgchTagRSAKeyValue            [] = { TWO_BYTES('R', 'S'), TWO_BYTES('A', 'K'), TWO_BYTES('e', 'y'), TWO_BYTES('V', 'a'), TWO_BYTES('l', 'u'), TWO_BYTES('e', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagRSAKeyValue_LEN 11
const DRM_CHAR  g_rgchTagModulus                [] = { TWO_BYTES('M', 'o'), TWO_BYTES('d', 'u'), TWO_BYTES('l', 'u'), TWO_BYTES('s', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagModulus_LEN 7
const DRM_CHAR  g_rgchTagExponent               [] = { TWO_BYTES('E', 'x'), TWO_BYTES('p', 'o'), TWO_BYTES('n', 'e'), TWO_BYTES('n', 't'), TWO_BYTES('\0', '\0') };
#define g_rgchTagExponent_LEN 8

const DRM_CHAR  g_rgchTagManufacturerName       [] = { TWO_BYTES('c', ':'), TWO_BYTES('M', 'a'), TWO_BYTES('n', 'u'), TWO_BYTES('f', 'a'), TWO_BYTES('c', 't'), TWO_BYTES('u', 'r'), TWO_BYTES('e', 'r'), TWO_BYTES('N', 'a'), TWO_BYTES('m', 'e'), TWO_BYTES('\0', '\0') };
#define g_rgchTagManufacturerName_LEN 18
const DRM_CHAR  g_rgchTagManufacturerData       [] = { TWO_BYTES('c', ':'), TWO_BYTES('M', 'a'), TWO_BYTES('n', 'u'), TWO_BYTES('f', 'a'), TWO_BYTES('c', 't'), TWO_BYTES('u', 'r'), TWO_BYTES('e', 'r'), TWO_BYTES('D', 'a'), TWO_BYTES('t', 'a'), TWO_BYTES('\0', '\0') }; 
#define g_rgchTagManufacturerData_LEN 18
const DRM_CHAR  g_rgchTagModelName              [] = { TWO_BYTES('c', ':'), TWO_BYTES('M', 'o'), TWO_BYTES('d', 'e'), TWO_BYTES('l', 'N'), TWO_BYTES('a', 'm'), TWO_BYTES('e', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagModelName_LEN 11
const DRM_CHAR  g_rgchTagModelNumber            [] = { TWO_BYTES('c', ':'), TWO_BYTES('M', 'o'), TWO_BYTES('d', 'e'), TWO_BYTES('l', 'N'), TWO_BYTES('u', 'm'), TWO_BYTES('b', 'e'), TWO_BYTES('r', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagModelNumber_LEN 13
const DRM_CHAR  g_rgchTagHardwareID               [] = { TWO_BYTES('c', ':'), TWO_BYTES('H', 'a'), TWO_BYTES('r', 'd'), TWO_BYTES('w', 'a'), TWO_BYTES('r', 'e'), TWO_BYTES('I', 'D'), TWO_BYTES('\0', '\0') };
#define g_rgchTagHardwareID_LEN 12
const DRM_CHAR  g_rgchURIRSASHA1                [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 'w'), TWO_BYTES('w', 'w'), TWO_BYTES('.', 'w'), TWO_BYTES('3', '.'), TWO_BYTES('o', 'r'), TWO_BYTES('g', '/'), TWO_BYTES('2', '0'), TWO_BYTES('0', '0'), TWO_BYTES('/', '0'), TWO_BYTES('9', '/'), TWO_BYTES('x', 'm'), TWO_BYTES('l', 'd'), TWO_BYTES('s', 'i'), TWO_BYTES('g', '#'), TWO_BYTES('r', 's'), TWO_BYTES('a', '-'), TWO_BYTES('s', 'h'), TWO_BYTES('a', '1'), TWO_BYTES('\0', '\0') };
#define g_rgchURIRSASHA1_LEN 42
const DRM_CHAR  g_rgchURIRSASHA1_Old            [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 's'), TWO_BYTES('c', 'h'), TWO_BYTES('e', 'm'), TWO_BYTES('a', 's'), TWO_BYTES('.', 'm'), TWO_BYTES('i', 'c'), TWO_BYTES('r', 'o'), TWO_BYTES('s', 'o'), TWO_BYTES('f', 't'), TWO_BYTES('.', 'c'), TWO_BYTES('o', 'm'), TWO_BYTES('/', 'D'), TWO_BYTES('R', 'M'), TWO_BYTES('/', '2'), TWO_BYTES('0', '0'), TWO_BYTES('4', '/'), TWO_BYTES('0', '2'), TWO_BYTES('/', 'C'), TWO_BYTES('E', 'R'), TWO_BYTES('T', '/'), TWO_BYTES('R', 's'), TWO_BYTES('a', '-'), TWO_BYTES('s', 'h'), TWO_BYTES('a', '1'), TWO_BYTES('\0', '\0') };
#define g_rgchURIRSASHA1_Old_LEN 54
const DRM_CHAR  g_rgchTagReference              [] = { TWO_BYTES('R', 'e'), TWO_BYTES('f', 'e'), TWO_BYTES('r', 'e'), TWO_BYTES('n', 'c'), TWO_BYTES('e', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagReference_LEN 9
const DRM_CHAR  g_rgchTagTransforms             [] = { TWO_BYTES('T', 'r'), TWO_BYTES('a', 'n'), TWO_BYTES('s', 'f'), TWO_BYTES('o', 'r'), TWO_BYTES('m', 's'), TWO_BYTES('\0', '\0') };
#define g_rgchTagTransforms_LEN 10
const DRM_CHAR  g_rgchTagTransform              [] = { TWO_BYTES('T', 'r'), TWO_BYTES('a', 'n'), TWO_BYTES('s', 'f'), TWO_BYTES('o', 'r'), TWO_BYTES('m', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagTransform_LEN 9
const DRM_CHAR  g_rgchURITransformMSCert        [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 'w'), TWO_BYTES('w', 'w'), TWO_BYTES('.', 'm'), TWO_BYTES('i', 'c'), TWO_BYTES('r', 'o'), TWO_BYTES('s', 'o'), TWO_BYTES('f', 't'), TWO_BYTES('.', 'c'), TWO_BYTES('o', 'm'), TWO_BYTES('/', 'D'), TWO_BYTES('R', 'M'), TWO_BYTES('/', 'C'), TWO_BYTES('E', 'R'), TWO_BYTES('T', '/'), TWO_BYTES('v', '2'), TWO_BYTES('/', 'D'), TWO_BYTES('a', 't'), TWO_BYTES('a', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchURITransformMSCert_LEN 41
const DRM_CHAR  g_rgchURITransformMSCertColl    [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 's'), TWO_BYTES('c', 'h'), TWO_BYTES('e', 'm'), TWO_BYTES('a', 's'), TWO_BYTES('.', 'm'), TWO_BYTES('i', 'c'), TWO_BYTES('r', 'o'), TWO_BYTES('s', 'o'), TWO_BYTES('f', 't'), TWO_BYTES('.', 'c'), TWO_BYTES('o', 'm'), TWO_BYTES('/', 'D'), TWO_BYTES('R', 'M'), TWO_BYTES('/', '2'), TWO_BYTES('0', '0'), TWO_BYTES('4', '/'), TWO_BYTES('0', '2'), TWO_BYTES('/', 'c'), TWO_BYTES('e', 'r'), TWO_BYTES('t', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchURITransformMSCertColl_LEN 45
const DRM_CHAR  g_rgchURITransformMSCert_Old    [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 's'), TWO_BYTES('c', 'h'), TWO_BYTES('e', 'm'), TWO_BYTES('a', 's'), TWO_BYTES('.', 'm'), TWO_BYTES('i', 'c'), TWO_BYTES('r', 'o'), TWO_BYTES('s', 'o'), TWO_BYTES('f', 't'), TWO_BYTES('.', 'c'), TWO_BYTES('o', 'm'), TWO_BYTES('/', 'D'), TWO_BYTES('R', 'M'), TWO_BYTES('/', '2'), TWO_BYTES('0', '0'), TWO_BYTES('4', '/'), TWO_BYTES('0', '2'), TWO_BYTES('/', 'C'), TWO_BYTES('E', 'R'), TWO_BYTES('T', '/'), TWO_BYTES('D', 'a'), TWO_BYTES('t', 'a'), TWO_BYTES('\0', '\0') };
#define g_rgchURITransformMSCert_Old_LEN 50
const DRM_CHAR  g_rgchURITransformC14N          [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 'w'), TWO_BYTES('w', 'w'), TWO_BYTES('.', 'w'), TWO_BYTES('3', '.'), TWO_BYTES('o', 'r'), TWO_BYTES('g', '/'), TWO_BYTES('T', 'R'), TWO_BYTES('/', '2'), TWO_BYTES('0', '0'), TWO_BYTES('1', '/'), TWO_BYTES('R', 'E'), TWO_BYTES('C', '-'), TWO_BYTES('x', 'm'), TWO_BYTES('l', '-'), TWO_BYTES('c', '1'), TWO_BYTES('4', 'n'), TWO_BYTES('-', '2'), TWO_BYTES('0', '0'), TWO_BYTES('1', '0'), TWO_BYTES('3', '1'), TWO_BYTES('5', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchURITransformC14N_LEN 47
const DRM_CHAR  g_rgchTagWMDRMCertificate       [] = { TWO_BYTES('c', ':'), TWO_BYTES('C', 'e'), TWO_BYTES('r', 't'), TWO_BYTES('i', 'f'), TWO_BYTES('i', 'c'), TWO_BYTES('a', 't'), TWO_BYTES('e', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagWMDRMCertificate_LEN 13
const DRM_CHAR  g_rgchTagWMDRMCertSecurityVersion[]= { TWO_BYTES('c', ':'), TWO_BYTES('S', 'e'), TWO_BYTES('c', 'u'), TWO_BYTES('r', 'i'), TWO_BYTES('t', 'y'), TWO_BYTES('V', 'e'), TWO_BYTES('r', 's'), TWO_BYTES('i', 'o'), TWO_BYTES('n', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagWMDRMCertSecurityVersion_LEN 17
const DRM_CHAR  g_rgchTagWMDRMCertSecurityLevel [] = { TWO_BYTES('c', ':'), TWO_BYTES('S', 'e'), TWO_BYTES('c', 'u'), TWO_BYTES('r', 'i'), TWO_BYTES('t', 'y'), TWO_BYTES('L', 'e'), TWO_BYTES('v', 'e'), TWO_BYTES('l', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagWMDRMCertSecurityLevel_LEN 15
const DRM_CHAR  g_rgchTagWMDRMCertSerialNumber  [] = { TWO_BYTES('c', ':'), TWO_BYTES('S', 'e'), TWO_BYTES('r', 'i'), TWO_BYTES('a', 'l'), TWO_BYTES('N', 'u'), TWO_BYTES('m', 'b'), TWO_BYTES('e', 'r'), TWO_BYTES('\0', '\0') };
#define g_rgchTagWMDRMCertSerialNumber_LEN 14
const DRM_CHAR  g_rgchTagWMDRMCertFeatures      [] = { TWO_BYTES('c', ':'), TWO_BYTES('F', 'e'), TWO_BYTES('a', 't'), TWO_BYTES('u', 'r'), TWO_BYTES('e', 's'), TWO_BYTES('\0', '\0') };
#define g_rgchTagWMDRMCertFeatures_LEN 10
const DRM_CHAR  g_rgchTagWMDRMCertKeyUsage      [] = { TWO_BYTES('c', ':'), TWO_BYTES('K', 'e'), TWO_BYTES('y', 'U'), TWO_BYTES('s', 'a'), TWO_BYTES('g', 'e'), TWO_BYTES('\0', '\0') };
#define g_rgchTagWMDRMCertKeyUsage_LEN 10
const DRM_CHAR  g_rgchTagWMDRMCertPublicKey     [] = { TWO_BYTES('c', ':'), TWO_BYTES('P', 'u'), TWO_BYTES('b', 'l'), TWO_BYTES('i', 'c'), TWO_BYTES('K', 'e'), TWO_BYTES('y', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagWMDRMCertPublicKey_LEN 11
const DRM_CHAR  g_rgchTagDataWMDRM              [] = { TWO_BYTES('c', ':'), TWO_BYTES('D', 'a'), TWO_BYTES('t', 'a'), TWO_BYTES('\0', '\0') };
#define g_rgchTagDataWMDRM_LEN 6
const DRM_CHAR  g_rgchTagSignature              [] = { TWO_BYTES('S', 'i'), TWO_BYTES('g', 'n'), TWO_BYTES('a', 't'), TWO_BYTES('u', 'r'), TWO_BYTES('e', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagSignature_LEN 9
const DRM_CHAR  g_rgchTagSignatureMethod        [] = { TWO_BYTES('S', 'i'), TWO_BYTES('g', 'n'), TWO_BYTES('a', 't'), TWO_BYTES('u', 'r'), TWO_BYTES('e', 'M'), TWO_BYTES('e', 't'), TWO_BYTES('h', 'o'), TWO_BYTES('d', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchTagSignatureMethod_LEN 15
const DRM_CHAR  g_rgchTagSignedInfo             [] = { TWO_BYTES('S', 'i'), TWO_BYTES('g', 'n'), TWO_BYTES('e', 'd'), TWO_BYTES('I', 'n'), TWO_BYTES('f', 'o'), TWO_BYTES('\0', '\0') };
#define g_rgchTagSignedInfo_LEN 10
const DRM_CHAR  g_rgchURIC14N                   [] = { TWO_BYTES('h', 't'), TWO_BYTES('t', 'p'), TWO_BYTES(':', '/'), TWO_BYTES('/', 'w'), TWO_BYTES('w', 'w'), TWO_BYTES('.', 'w'), TWO_BYTES('3', '.'), TWO_BYTES('o', 'r'), TWO_BYTES('g', '/'), TWO_BYTES('T', 'R'), TWO_BYTES('/', '2'), TWO_BYTES('0', '0'), TWO_BYTES('1', '/'), TWO_BYTES('R', 'E'), TWO_BYTES('C', '-'), TWO_BYTES('x', 'm'), TWO_BYTES('l', '-'), TWO_BYTES('c', '1'), TWO_BYTES('4', 'n'), TWO_BYTES('-', '2'), TWO_BYTES('0', '0'), TWO_BYTES('1', '0'), TWO_BYTES('3', '1'), TWO_BYTES('5', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchURIC14N_LEN 47
const DRM_CHAR  g_rgchVersionWMDRM              [] = { TWO_BYTES('2', '.'), TWO_BYTES('0', '\0'), TWO_BYTES('\0', '\0') };
#define g_rgchVersionWMDRM_LEN 3
const DRM_CHAR  g_rgchWMDRMCertExponent         [] = { TWO_BYTES('A', 'Q'), TWO_BYTES('A', 'B'), TWO_BYTES('\0', '\0') };
#define g_rgchWMDRMCertExponent_LEN 4


const DRM_CHAR  g_rgchFeatureSampleProtection   [] = { TWO_BYTES('m', ':'), TWO_BYTES('W', 'M'), TWO_BYTES('D', 'R'), TWO_BYTES('M', 'S'), TWO_BYTES('a', 'm'), TWO_BYTES('p', 'l'), TWO_BYTES('e', 'P'), TWO_BYTES('r', 'o'), TWO_BYTES('t', 'e'), TWO_BYTES('c', 't'), TWO_BYTES('i', 'o'), TWO_BYTES('n', '\0') };
#define g_rgchFeatureSampleProtection_LEN 23
const DRM_CHAR  g_rgchFeatureExport                 [] = { TWO_BYTES('m', ':'), TWO_BYTES('W', 'M'), TWO_BYTES('D', 'R'), TWO_BYTES('M', 'E'), TWO_BYTES('x', 'p'), TWO_BYTES('o', 'r'), TWO_BYTES('t', '\0') };
#define g_rgchFeatureExport_LEN 13
const DRM_CHAR  g_rgchFeatureExportIncl             [] = { TWO_BYTES('m', ':'), TWO_BYTES('W', 'M'), TWO_BYTES('D', 'R'), TWO_BYTES('M', 'E'), TWO_BYTES('x', 'p'), TWO_BYTES('o', 'r'), TWO_BYTES('t', 'I'), TWO_BYTES('n', 'c'), TWO_BYTES('l', '\0') };
#define g_rgchFeatureExportIncl_LEN 17

const DRM_CHAR  g_rgchPrefixMicrosoftCert              [] = { TWO_BYTES('x', 'm'), TWO_BYTES('l', 'n'), TWO_BYTES('s', ':'), TWO_BYTES('c', '\0') };
#define g_rgchPrefixMicrosoftCert_LEN 7

const DRM_CHAR  g_rgchMSRootPubKey              [] =  { TWO_BYTES('p', 'j'), TWO_BYTES('o', 'e'), TWO_BYTES('W', 'L'), TWO_BYTES('S', 'T'), TWO_BYTES('L', 'D'), TWO_BYTES('o', 'n'), TWO_BYTES('Q', 'G'), TWO_BYTES('8', 'S'), TWO_BYTES('h', 'e'), TWO_BYTES('6', 'Q'), TWO_BYTES('h', 'k'), TWO_BYTES('Y', 'b'), TWO_BYTES('Y', 'o'), TWO_BYTES('t', 't'), TWO_BYTES('9', 'f'), TWO_BYTES('P', 'Z'), TWO_BYTES('8', 't'), TWO_BYTES('H', 'd'), TWO_BYTES('B', '1'), TWO_BYTES('2', '8'), TWO_BYTES('Z', 'E'), TWO_BYTES('T', 'c'), TWO_BYTES('g', 'h'), TWO_BYTES('n', '5'), TWO_BYTES('K', 'H'), TWO_BYTES('o', 'y'), TWO_BYTES('i', 'n'), TWO_BYTES('7', 'H'), TWO_BYTES('k', 'J'), TWO_BYTES('E', 'c'), TWO_BYTES('P', 'J'), TWO_BYTES('0', 'E'), TWO_BYTES('g', '4'), TWO_BYTES('U', 'd'), TWO_BYTES('S', 'v'), TWO_BYTES('a', '0'), TWO_BYTES('K', 'D'), TWO_BYTES('I', 'Y'), TWO_BYTES('D', 'j'), TWO_BYTES('A', '3'), TWO_BYTES('E', 'X'), TWO_BYTES('d', '6'), TWO_BYTES('9', 'R'), TWO_BYTES('3', 'C'), TWO_BYTES('N', '2'), TWO_BYTES('W', 'p'), TWO_BYTES('/', 'Q'), TWO_BYTES('y', 'O'), TWO_BYTES('o', '0'), TWO_BYTES('Z', 'P'), TWO_BYTES('Y', 'W'), TWO_BYTES('Y', 'p'), TWO_BYTES('3', 'N'), TWO_BYTES('X', 'p'), TWO_BYTES('J', '7'), TWO_BYTES('0', '0'), TWO_BYTES('t', 'K'), TWO_BYTES('P', 'g'), TWO_BYTES('I', 'p'), TWO_BYTES('l', 'z'), TWO_BYTES('o', '5'), TWO_BYTES('w', 'V'), TWO_BYTES('d', '/'), TWO_BYTES('6', '9'), TWO_BYTES('g', '7'), TWO_BYTES('j', '+'), TWO_BYTES('j', '8'), TWO_BYTES('M', '6'), TWO_BYTES('6', 'W'), TWO_BYTES('7', 'V'), TWO_BYTES('N', 'm'), TWO_BYTES('D', 'w'), TWO_BYTES('a', 'N'), TWO_BYTES('s', '9'), TWO_BYTES('m', 'D'), TWO_BYTES('c', '1'), TWO_BYTES('p', '2'), TWO_BYTES('+', 'V'), TWO_BYTES('V', 'M'), TWO_BYTES('s', 'D'), TWO_BYTES('h', 'O'), TWO_BYTES('s', 'V'), TWO_BYTES('/', 'A'), TWO_BYTES('u', '6'), TWO_BYTES('E', '+'), TWO_BYTES('E', '='), TWO_BYTES('\0', '\0') };
#define g_rgchMSRootPubKey_LEN 172


/* Secure clock Challenge\response XML tags */
const DRM_WCHAR      g_rgwchTagDRMReqRoot                         [] =  { ONE_WCHAR('D', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchResponse                              [] =  { ONE_WCHAR('r', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('p', '\0'),  ONE_WCHAR('o', '\0'),  ONE_WCHAR('n', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchStatus                                [] =  { ONE_WCHAR('s', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('a', '\0'),  ONE_WCHAR('t', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchFlag                                  [] =  { ONE_WCHAR('F', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagGmtTime                            [] =  { ONE_WCHAR('G', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagRefreshDate                        [] =  { ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('F', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};

/* Output Level strings */
const DRM_WCHAR      g_rgwchLabelGuid                             [] =  { ONE_WCHAR('g', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('d', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchLabelLevel                            [] =  { ONE_WCHAR('l', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('e', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagUncompressedDigitalVideo           [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagCompressedDigitalVideo             [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagUncompressedDigitalAudio           [] =  { ONE_WCHAR('U', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagCompressedDigitalAudio             [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('M', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagAnalogVideo                        [] =  { ONE_WCHAR('A', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagCopy                               [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagExtensionList                      [] =  { ONE_WCHAR('E', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagExtension                          [] =  { ONE_WCHAR('E', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagIncludeList                        [] =  { ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagInclude                            [] =  { ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagExcludeList                        [] =  { ONE_WCHAR('E', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagExclude                            [] =  { ONE_WCHAR('E', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('L', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchMSRootPubKey                          [] =  { ONE_WCHAR('0', '\0'),  ONE_WCHAR('X', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('s', '\0'),  ONE_WCHAR('V', '\0'),  ONE_WCHAR('w', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('H', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('R', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('w', '\0'),  ONE_WCHAR('3', '\0'),  ONE_WCHAR('w', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('1', '\0'),  ONE_WCHAR('v', '\0'),  ONE_WCHAR('q', '\0'),  ONE_WCHAR('j', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('4', '\0'),  ONE_WCHAR('6', '\0'),  ONE_WCHAR('Q', '\0'),  ONE_WCHAR('k', '\0'),  ONE_WCHAR('W', '\0'),  ONE_WCHAR('q', '\0'),  ONE_WCHAR('5', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('g', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('r', '\0'),  ONE_WCHAR('u', '\0'),  ONE_WCHAR('q', '\0'),  ONE_WCHAR('w', '\0'),  ONE_WCHAR('*', '\0'),  ONE_WCHAR('J', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('Z', '\0'),  ONE_WCHAR('l', '\0'),  ONE_WCHAR('c', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('!', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('i', '\0'),  ONE_WCHAR('y', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('3', '\0'),  ONE_WCHAR('6', '\0'),  ONE_WCHAR('h', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('w', '\0'),  ONE_WCHAR('=', '\0'),  ONE_WCHAR('=', '\0'),  ONE_WCHAR('\0', '\0')};

/* License State strings */
const DRM_WCHAR      g_rgwchTagLicenseStateRequestRoot            [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('C', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('T', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagCanBind                            [] =  { ONE_WCHAR('C', '\0'),  ONE_WCHAR('A', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('I', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('D', '\0'),  ONE_WCHAR('\0', '\0')};

/*Device License Revocation Blob Strings*/

const DRM_WCHAR      g_rgwchTagDeviceLicenseRevocationRoot        [] =  { ONE_WCHAR('R', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('O', '\0'),  ONE_WCHAR('N', '\0'),  ONE_WCHAR('S', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('\0', '\0')};
const DRM_WCHAR      g_rgwchTagRevocationPubKey                   [] =  { ONE_WCHAR('L', '\0'),  ONE_WCHAR('G', '\0'),  ONE_WCHAR('P', '\0'),  ONE_WCHAR('U', '\0'),  ONE_WCHAR('B', '\0'),  ONE_WCHAR('K', '\0'),  ONE_WCHAR('E', '\0'),  ONE_WCHAR('Y', '\0'),  ONE_WCHAR('\0', '\0')};

/* Strings to be used from DRMManager */
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_PLAYBACK                   = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_PLAYBACK );
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_COLLABORATIVE_PLAY         = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_COLLABORATIVE_PLAY );
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_COPY_TO_CD                 = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_COPY_TO_CD );
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_COPY                       = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_COPY );
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_CREATE_THUMBNAIL_IMAGE     = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_CREATE_THUMBNAIL_IMAGE );

#if DRM_SUPPORT_PMLICENSE
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_COPY_TO_SDMI_DEVICE        = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_COPY_TO_SDMI_DEVICE );
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_COPY_TO_NON_SDMI_DEVICE    = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_COPY_TO_NON_SDMI_DEVICE );
#endif

#if DRM_BACKUP_RESTORE_SUPPORT
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_BACKUP                     = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_BACKUP );
#endif

#if DRM_SUPPORT_PLAYLIST_BURN
const DRM_CONST_STRING      g_dstrPlaylistBurnCount                     = CREATE_DRM_STRING( g_rgwchPlaylistBurnCount );
const DRM_CONST_STRING      g_dstrWMDRM_RIGHT_PLAYLIST_BURN             = CREATE_DRM_STRING( g_rgwchWMDRM_RIGHT_PLAYLIST_BURN );
#endif


/* String constants */
const DRM_ANSI_CONST_STRING g_adstrAttributeVersion                     = { g_rgchAttributeVersion,   7 }; /* Special case these odd length ANSI strings */
const DRM_ANSI_CONST_STRING g_dastrTagLicense                           = { g_rgchLicenseTag,         7 };
const DRM_ANSI_CONST_STRING g_adstrLicenseRespTag                       = { g_rgchLicenseRespTag,    15 };
const DRM_ANSI_CONST_STRING g_adstrAttributeEncrypted                   = { g_rgchAttributeEncrypted, 9 };
const DRM_ANSI_CONST_STRING g_dastrAttributeFALSE                       = { g_rgchAttributeFALSE,     5 };

const DRM_ANSI_CONST_STRING g_dastrTagSLK                               = { g_rgchTagSLK,     3 };
const DRM_ANSI_CONST_STRING g_dastrTagSLKID                             = { g_rgchTagSLKID,   5 };
const DRM_ANSI_CONST_STRING g_dastrTagSLKDATA                           = { g_rgchTagSLKDATA, 7 };

const DRM_CONST_STRING      g_dstrTagSLK                                = CREATE_DRM_STRING( g_rgwchTagSLK    );
const DRM_CONST_STRING      g_dstrTagSLKID                              = CREATE_DRM_STRING( g_rgwchTagSLKID  );
const DRM_CONST_STRING      g_dstrTagSLKDATA                            = CREATE_DRM_STRING( g_rgwchTagSLKDATA);

const DRM_CONST_STRING      g_dstrAttributeVersion                      = CREATE_DRM_STRING( g_rgwchAttributeVersion );
const DRM_CONST_STRING      g_dstrAttributeEncrypted                    = CREATE_DRM_STRING( g_rgwchAttributeEncrypted );
const DRM_CONST_STRING      g_dstrAttributeFALSE                        = CREATE_DRM_STRING( g_rgwchAttributeFALSE );
const DRM_CONST_STRING      g_dstrLicVerAttrValue                       = CREATE_DRM_STRING( g_rgwchLicVerAttrValue );
const DRM_CONST_STRING      g_dstrLicenseRespTag                        = CREATE_DRM_STRING( g_rgwchLicenseRespTag );
const DRM_CONST_STRING      g_dstrTagLicense                            = CREATE_DRM_STRING( g_rgwchLicenseTag );

/* Script varibles used for license properties. */
const DRM_CONST_STRING      g_dstrDRM_LS_BEGIN_ATTR                     = CREATE_DRM_STRING( g_rgwchDRM_LS_BEGIN_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_COUNT_ATTR                     = CREATE_DRM_STRING( g_rgwchDRM_LS_COUNT_ATTR );

const DRM_CONST_STRING      g_dstrDRM_LS_BEGDATE_ATTR                   = CREATE_DRM_STRING( g_rgwchDRM_LS_BEGDATE_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_ENDDATE_ATTR                   = CREATE_DRM_STRING( g_rgwchDRM_LS_ENDDATE_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_FIRSTUSE_ATTR                  = CREATE_DRM_STRING( g_rgwchDRM_LS_FIRSTUSE_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_EXPIRATION_AFTER_FIRSTUSE_ATTR = CREATE_DRM_STRING( g_rgwchDRM_LS_EXPIRATION_AFTER_FIRSTUSE_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_MINAPPSECLEVEL_ATTR            = CREATE_DRM_STRING( g_rgwchDRM_LS_MINAPPSECLEVEL_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_APPSEC_ATTR                    = CREATE_DRM_STRING( g_rgwchDRM_LS_APPSEC_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_BURNTOCDCOUNT_ATTR             = CREATE_DRM_STRING( g_rgwchDRM_LS_BURNTOCDCOUNT_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_TRANSFERCOUNT_ATTR             = CREATE_DRM_STRING( g_rgwchDRM_LS_TRANSFERCOUNT_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_PLAYCOUNT_ATTR                 = CREATE_DRM_STRING( g_rgwchDRM_LS_PLAYCOUNT_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_BEGINBURNTOCDCOUNT_ATTR        = CREATE_DRM_STRING( g_rgwchDRM_LS_BEGINBURNTOCDCOUNT_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_BEGINTRANSFERCOUNT_ATTR        = CREATE_DRM_STRING( g_rgwchDRM_LS_BEGINTRANSFERCOUNT_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_BEGINPLAYCOUNT_ATTR            = CREATE_DRM_STRING( g_rgwchDRM_LS_BEGINPLAYCOUNT_ATTR );

const DRM_CONST_STRING      g_dstrDRM_LS_DELETED_ATTR                   = CREATE_DRM_STRING( g_rgwchDRM_LS_DELETED_ATTR );

#if DRM_SUPPORT_ANTIROLLBACK_CLOCK
const DRM_CONST_STRING      g_dstrDRM_LS_OLDSAVETIME_ATTR               = CREATE_DRM_STRING( g_rgwchDRM_LS_OLDSAVETIME_ATTR );
const DRM_CONST_STRING      g_dstrDRM_LS_MACHINE_DATETIME               = CREATE_DRM_STRING( g_rgwchDRM_LS_MACHINE_DATETIME );
#endif

const DRM_CONST_STRING      g_dstrDRM_LS_MACHINE_DATETIME_GE            = CREATE_DRM_STRING( g_rgwchDRM_LS_MACHINE_DATETIME_GE );
const DRM_CONST_STRING      g_dstrDRM_LS_MACHINE_DATETIME_LE            = CREATE_DRM_STRING( g_rgwchDRM_LS_MACHINE_DATETIME_LE );
const DRM_CONST_STRING      g_dstrDRM_LS_APP_MINSECLEVEL_GE             = CREATE_DRM_STRING( g_rgwchDRM_LS_APP_MINSECLEVEL_GE );
const DRM_CONST_STRING      g_dstrEqual                                 = CREATE_DRM_STRING( g_rgwchEqual );

const DRM_CONST_STRING      g_dstrDrmRestoreInfo                        = CREATE_DRM_STRING( g_rgwchDrmRestoreInfo );
const DRM_CONST_STRING      g_dstrTagData                               = CREATE_DRM_STRING( g_rgwchTagData );
const DRM_CONST_STRING      g_dstrTagDataInclusionList                  = CREATE_DRM_STRING( g_rgwchTagDataInclusionList );
const DRM_CONST_STRING      g_dstrTagLID                                = CREATE_DRM_STRING( g_rgwchTagLID );

const DRM_CONST_STRING      g_dstrTagIndex                              = CREATE_DRM_STRING( g_rgwchTagIndex );
const DRM_CONST_STRING      g_dstrTagEnablingbits                       = CREATE_DRM_STRING( g_rgwchTagEnablingbits );
const DRM_CONST_STRING      g_dstrTagSymValue                           = CREATE_DRM_STRING( g_rgwchTagSymValue );
const DRM_CONST_STRING      g_dstrTagSymSig                             = CREATE_DRM_STRING( g_rgwchTagSymSig );
const DRM_CONST_STRING      g_dstrTagHashAlgorithm                      = CREATE_DRM_STRING( g_rgwchTagHashAlgorithm );
const DRM_CONST_STRING      g_dstrTagPubkey                             = CREATE_DRM_STRING( g_rgwchTagPubkey );
const DRM_CONST_STRING      g_dstrTagValue                              = CREATE_DRM_STRING( g_rgwchTagValue );
const DRM_CONST_STRING      g_dstrTagSignature                          = CREATE_DRM_STRING( g_rgwchTagSignature );
const DRM_CONST_STRING      g_dstrTagHashAlg                            = CREATE_DRM_STRING( g_rgwchTagHashAlg );
const DRM_CONST_STRING      g_dstrTagSignAlg                            = CREATE_DRM_STRING( g_rgwchTagSignAlg );
const DRM_CONST_STRING      g_dstrSHA                                   = CREATE_DRM_STRING( g_rgwchSHA );
const DRM_CONST_STRING      g_dstrMSDRM                                 = CREATE_DRM_STRING( g_rgwchMSDRM );
const DRM_CONST_STRING      g_dstrMSDRM_CK                              = CREATE_DRM_STRING( g_rgwchMSDRM_CK );
const DRM_ANSI_CONST_STRING g_dastrAttributeType                        = { g_rgchAttributeType, 4 };
const DRM_CONST_STRING      g_dstrAttributeType                         = CREATE_DRM_STRING( g_rgwchAttributeType );
const DRM_CONST_STRING      g_dstrSavedDateTime                         = CREATE_DRM_STRING( g_rgwchSavedDateTime );

#if DRM_SUPPORT_ANTIROLLBACK_CLOCK
const DRM_CONST_STRING      g_dstrCheckClockRollback                    = CREATE_DRM_STRING( g_rgwchCheckClockRollback );
const DRM_CONST_STRING      g_dstrResetRollbackedClock                  = CREATE_DRM_STRING( g_rgwchResetRollbackedClock );
#endif

const DRM_CONST_STRING      g_dstrSetSavedDateTime                      = CREATE_DRM_STRING( g_rgwchSetSavedDateTime );
const DRM_CONST_STRING      g_dstrCreatePMLicense                       = CREATE_DRM_STRING( g_rgwchCreatePMLicense );
const DRM_CONST_STRING      g_dstrVersion_1_0                           = CREATE_DRM_STRING( g_rgwchVersion_1_0 );
const DRM_CONST_STRING      g_dstrTagDevinfo                            = CREATE_DRM_STRING( g_rgwchTagDevinfo );
const DRM_CONST_STRING      g_dstrTagFallback                           = CREATE_DRM_STRING( g_rgwchTagFallback );
const DRM_CONST_STRING      g_dstrTagError                              = CREATE_DRM_STRING( g_rgwchTagError );
const DRM_CONST_STRING      g_dstrXPathSigValue                         = CREATE_DRM_STRING( g_rgwchXPathSigValue );
const DRM_CONST_STRING      g_dstrCompatCert                            = CREATE_DRM_STRING( g_rgwchCompatCert );
const DRM_CONST_STRING      g_dstrCompatSecVersion                      = CREATE_DRM_STRING( g_rgwchCompatSecVersion );
const DRM_CONST_STRING      g_dstrSubjectId                             = CREATE_DRM_STRING( g_rgwchSubjectId );
const DRM_CONST_STRING      g_dstrMaxSecLevel                           = CREATE_DRM_STRING( g_rgwchMaxSecLevel );
const DRM_CONST_STRING      g_dstrAuthSecVer                            = CREATE_DRM_STRING( g_rgwchAuthSecVer );
const DRM_CONST_STRING      g_dstrAuthPubKey                            = CREATE_DRM_STRING( g_rgwchAuthPubKey );
const DRM_CONST_STRING      g_dstrXPathTagSignature                     = CREATE_DRM_STRING( g_rgwchXPathTagSignature );
const DRM_CONST_STRING      g_dstrTagSignatureVal                       = CREATE_DRM_STRING( g_rgwchTagSignatureVal );
const DRM_CONST_STRING      g_dstrXPathTagCertificateChain              = CREATE_DRM_STRING( g_rgwchXPathTagCertificateChain );
const DRM_CONST_STRING      g_dstrAuthData                              = CREATE_DRM_STRING( g_rgwchAuthData );
const DRM_CONST_STRING      g_dstrAuthHashAlg                           = CREATE_DRM_STRING( g_rgwchAuthHashAlg );
const DRM_CONST_STRING      g_dstrAuthSignAlg                           = CREATE_DRM_STRING( g_rgwchAuthSignAlg );
const DRM_CONST_STRING      g_dstrFallback                              = CREATE_DRM_STRING( g_rgwchFallback );


const DRM_CONST_STRING      g_dstrXPathTagSecurityLevel                 = CREATE_DRM_STRING( g_rgwchXPathTagSecurityLevel );

const DRM_CONST_STRING      g_dstrXPathTagCertificate                   = CREATE_DRM_STRING( g_rgwchXPathTagCertificate );
const DRM_CONST_STRING      g_dstrXPathDataUniqueID                     = CREATE_DRM_STRING( g_rgwchXPathDataUniqueID );

const DRM_CONST_STRING      g_dstrXPathManufacturer                     = CREATE_DRM_STRING( g_rgwchXPathManufacturer );
const DRM_CONST_STRING      g_dstrXPathMake                             = CREATE_DRM_STRING( g_rgwchXPathMake );
const DRM_CONST_STRING      g_dstrXPathModel                            = CREATE_DRM_STRING( g_rgwchXPathModel );
const DRM_CONST_STRING      g_dstrXPathDistributor                      = CREATE_DRM_STRING( g_rgwchXPathDistributor );
const DRM_CONST_STRING      g_dstrXPathHardwareMajor                    = CREATE_DRM_STRING( g_rgwchXPathHardwareMajor );
const DRM_CONST_STRING      g_dstrXPathHardwareMinor                    = CREATE_DRM_STRING( g_rgwchXPathHardwareMinor );
const DRM_CONST_STRING      g_dstrXPathFirmwareMajor                    = CREATE_DRM_STRING( g_rgwchXPathFirmwareMajor );
const DRM_CONST_STRING      g_dstrXPathFirmwareMinor                    = CREATE_DRM_STRING( g_rgwchXPathFirmwareMinor );
const DRM_CONST_STRING      g_dstrXPathFeatureTemplate                  = CREATE_DRM_STRING( g_rgwchXPathFeatureTemplate );
const DRM_CONST_STRING      g_dstrXPathClientOldKeys                    = CREATE_DRM_STRING( g_rgwchXPathClientOldKeys );
const DRM_CONST_STRING      g_dstrXPathClientEscrowKeys                 = CREATE_DRM_STRING( g_rgwchXPathClientEscrowKeys );
const DRM_CONST_STRING      g_dstrXPathClientEscrowKey                  = CREATE_DRM_STRING( g_rgwchXPathClientEscrowKey );
const DRM_CONST_STRING      g_dstrXPathIndivServerEscrowKey             = CREATE_DRM_STRING( g_rgwchXPathIndivServerEscrowKey );
const DRM_CONST_STRING      g_dstrXPathDevicePublicKey                  = CREATE_DRM_STRING( g_rgwchXPathDevicePublicKey );
const DRM_CONST_STRING      g_dstrXPathOldKeysData                      = CREATE_DRM_STRING( g_rgwchXPathOldKeysData );
const DRM_CONST_STRING      g_dstrXPathIndivSvrPubKey                   = CREATE_DRM_STRING( g_rgwchXPathIndivSvrPubKey );
const DRM_CONST_STRING      g_dstrXPathSecureClock                      = CREATE_DRM_STRING( g_rgwchXPathSecureClock );
const DRM_CONST_STRING      g_dstrXPathIndivType                        = CREATE_DRM_STRING( g_rgwchXPathIndivType );
const DRM_CONST_STRING      g_dstrXPathSecureStore                      = CREATE_DRM_STRING( g_rgwchXPathSecureStore );
const DRM_CONST_STRING      g_dstrXPathMetering                         = CREATE_DRM_STRING( g_rgwchXPathMetering );
const DRM_CONST_STRING      g_dstrXPathLicenseChain                     = CREATE_DRM_STRING( g_rgwchXPathLicenseChain );


const DRM_CONST_STRING      g_dstrTagDevCert                            = CREATE_DRM_STRING( g_rgwchTagDevCert );
const DRM_CONST_STRING      g_dstrTagWrmHeader                          = CREATE_DRM_STRING( g_rgwchTagWrmHeader );
const DRM_CONST_STRING      g_dstrAttributeVersionValue                 = CREATE_DRM_STRING( g_rgwchAttributeVersionValue );
const DRM_CONST_STRING      g_dstrTagLAINFO                             = CREATE_DRM_STRING( g_rgwchTagLAINFO );
const DRM_CONST_STRING      g_dstrTagKID                                = CREATE_DRM_STRING( g_rgwchTagKID );
const DRM_CONST_STRING      g_dstrTagChecksum                           = CREATE_DRM_STRING( g_rgwchTagChecksum );
const DRM_CONST_STRING      g_dstrXPathHeaderUplinks                    = CREATE_DRM_STRING( g_rgwchXPathHeaderUplinks );
const DRM_CONST_STRING      g_dstrTagUplink                             = CREATE_DRM_STRING( g_rgwchTagUplink );
const DRM_CONST_STRING      g_dstrTagUplinks                            = CREATE_DRM_STRING( g_rgwchTagUplinks );

const DRM_CONST_STRING      g_dstrTagLicenseRequest                     = CREATE_DRM_STRING( g_rgwchTagLicenseRequest );
const DRM_CONST_STRING      g_dstrTagAction                             = CREATE_DRM_STRING( g_rgwchTagAction );

const DRM_CONST_STRING      g_dstrTagV1Challenge                        = CREATE_DRM_STRING( g_rgwchTagV1Challenge );
const DRM_CONST_STRING      g_dstrDefaultV1Data                         = CREATE_DRM_STRING( g_rgwchDefaultV1Data );
const DRM_CONST_STRING      g_dstrTagActionList                         = CREATE_DRM_STRING( g_rgwchTagActionList );
const DRM_CONST_STRING      g_dstrTagSecurityVersion                    = CREATE_DRM_STRING( g_rgwchTagSecurityVersion );


/*
**  Devcert Non-indiv Tags
*/
const DRM_CONST_STRING      g_dstrTagDNIUniqueID                        = CREATE_DRM_STRING( g_rgwchTagDNIUniqueID );
const DRM_CONST_STRING      g_dstrTagMSDRMSignature                     = CREATE_DRM_STRING( g_rgwchTagMSDRMSignature );
const DRM_CONST_STRING      g_dstrPrivateKeys                           = CREATE_DRM_STRING( g_rgwchPrivateKeys );
const DRM_CONST_STRING      g_dstrCertTypeDevice                        = CREATE_DRM_STRING( g_rgwchCertTypeDevice );
const DRM_CONST_STRING      g_dstrCerttypeGroup                         = CREATE_DRM_STRING( g_rgwchCerttypeGroup );
const DRM_CONST_STRING      g_dstrCerttypeAuth                          = CREATE_DRM_STRING( g_rgwchCerttypeAuth );
const DRM_CONST_STRING      g_dstrCerttypeAuthRoot                      = CREATE_DRM_STRING( g_rgwchCerttypeAuthRoot );

/*
**  Devcert Non-indiv XPaths
*/
const DRM_CONST_STRING      g_dstrXPathPubkeyData                       = CREATE_DRM_STRING( g_rgwchXPathPubkeyData );
const DRM_CONST_STRING      g_dstrXPathGCSecureClock                    = CREATE_DRM_STRING( g_rgwchXPathGCSecureClock );
const DRM_CONST_STRING      g_dstrXPathGCSecureClockURL                 = CREATE_DRM_STRING( g_rgwchXPathGCSecureClockURL );
const DRM_CONST_STRING      g_dstrXPathGCSecureClockPubKey              = CREATE_DRM_STRING( g_rgwchXPathGCSecureClockPubKey );
const DRM_CONST_STRING      g_dstrXPathGCMetering                       = CREATE_DRM_STRING( g_rgwchXPathGCMetering );
const DRM_CONST_STRING      g_dstrXPathGCLicenseAcquisitionMode         = CREATE_DRM_STRING( g_rgwchXPathGCLicenseAcquisitionMode );
const DRM_CONST_STRING      g_dstrXPathGCLicenseSyncMode                = CREATE_DRM_STRING( g_rgwchXPathGCLicenseSyncMode );
const DRM_CONST_STRING      g_dstrXPathGCSymmOptsMode                   = CREATE_DRM_STRING( g_rgwchXPathGCSymmOpts );
const DRM_CONST_STRING      g_dstrXPathGCEncryption                     = CREATE_DRM_STRING( g_rgwchXPathGCEncryption );
const DRM_CONST_STRING      g_dstrXPathGCMaxChainDepth                  = CREATE_DRM_STRING( g_rgwchXPathGCMaxChainDepth );
const DRM_CONST_STRING      g_dstrXPathGCMaxLicenseSize                 = CREATE_DRM_STRING( g_rgwchXPathGCMaxLicenseSize );
const DRM_CONST_STRING      g_dstrXPathGCMaxHeaderSize                  = CREATE_DRM_STRING( g_rgwchXPathGCMaxHeaderSize );
const DRM_CONST_STRING      g_dstrXPathDeviceKeydata                    = CREATE_DRM_STRING( g_rgwchXPathDeviceKeydata );
const DRM_CONST_STRING      g_dstrXPathDACAuthID                        = CREATE_DRM_STRING( g_rgwchXPathDACAuthID );

const DRM_CONST_STRING      g_dstrReqTagClientInfo                      = CREATE_DRM_STRING( g_rgwchReqTagClientInfo );
const DRM_CONST_STRING      g_dstrReqTagClientID                        = CREATE_DRM_STRING( g_rgwchReqTagClientID );
const DRM_CONST_STRING      g_dstrReqTagClientVersion                   = CREATE_DRM_STRING( g_rgwchReqTagClientVersion );
const DRM_CONST_STRING      g_dstrReqTagAppSecurity                     = CREATE_DRM_STRING( g_rgwchReqTagAppSecurity );
const DRM_CONST_STRING      g_dstrReqTagSubjectID1                      = CREATE_DRM_STRING( g_rgwchReqTagSubjectID1 );
const DRM_CONST_STRING      g_dstrReqTagSubjectID2                      = CREATE_DRM_STRING( g_rgwchReqTagSubjectID2 );
const DRM_CONST_STRING      g_dstrReqTagDrmkVersion                     = CREATE_DRM_STRING( g_rgwchReqTagDrmkVersion );
const DRM_CONST_STRING      g_dstrReqTagClientVersionData               = CREATE_DRM_STRING( g_rgwchReqTagClientVersionData );
const DRM_CONST_STRING      g_dstrReqTagSubjectID2Data                  = CREATE_DRM_STRING( g_rgwchReqTagSubjectID2Data );
const DRM_CONST_STRING      g_dstrReqTagDrmkData                        = CREATE_DRM_STRING( g_rgwchReqTagDrmkData );

/* Xml tags used in parsing licenses */
const DRM_CONST_STRING      g_dstrLicense                               = CREATE_DRM_STRING( g_rgwchLicense );
const DRM_CONST_STRING      g_dstrGUID                                  = CREATE_DRM_STRING( g_rgwchGUID );
const DRM_CONST_STRING      g_dstrLicensorInfoNode                      = CREATE_DRM_STRING( g_rgwchLicensorInfoNode );
const DRM_CONST_STRING      g_dstrLIData                                = CREATE_DRM_STRING( g_rgwchLIData );
const DRM_CONST_STRING      g_dstrMeta                                  = CREATE_DRM_STRING( g_rgwchMeta );

const DRM_ANSI_CONST_STRING g_dastrTagRevocation                        = { g_rgchTagRevocation, 10 };
const DRM_CONST_STRING      g_dstrTagRevocation                         = CREATE_DRM_STRING( g_rgwchTagRevocation );
const DRM_CONST_STRING      g_dstrAppRevocation                         = CREATE_DRM_STRING( g_rgwchAppRevocation );
const DRM_CONST_STRING      g_dstrDeviceRevocation                      = CREATE_DRM_STRING( g_rgwchDeviceRevocation );
const DRM_ANSI_CONST_STRING g_dastrTagRevocationInfo                    = { g_rgchTagRevocationInfo, 14 };
const DRM_CONST_STRING      g_dstrTagRevocationInfo                     = CREATE_DRM_STRING( g_rgwchTagRevocationInfo );
const DRM_ANSI_CONST_STRING g_dastrDeviceRevocation                     = CREATE_DRM_ANSI_STRING( g_rgchDeviceRevocation );
const DRM_CONST_STRING      g_dstrDeviceRevocationList                  = CREATE_DRM_STRING( g_rgwchDeviceRevocationList );
const DRM_CONST_STRING      g_dstrWMDRMNET_Revocation                   = CREATE_DRM_STRING( g_rgwchWMDRMNET_Revocation );
const DRM_ANSI_CONST_STRING g_dastrWMDRMNET_Revocation                  = CREATE_DRM_ANSI_STRING(  g_rgchWMDRMNET_Revocation );
const DRM_CONST_STRING      g_dstrTagRevInfoVersion                     = CREATE_DRM_STRING( g_rgwchTagRevInfoVersion );
const DRM_ANSI_CONST_STRING g_dastrTagRevInfoVersion                    = CREATE_DRM_ANSI_STRING( g_rgchTagRevInfoVersion );
const DRM_CONST_STRING      g_dstrTagSourceID                           = CREATE_DRM_STRING( g_rgwchTagSourceID );
const DRM_ANSI_CONST_STRING g_dastrTagSourceID                          = CREATE_DRM_ANSI_STRING( g_rgchTagSourceID );
const DRM_CONST_STRING      g_dstrTagInclusionList                      = CREATE_DRM_STRING( g_rgwchInclusionList );

const DRM_CONST_STRING      g_dstrDeviceRevocationLicenseTag            = CREATE_DRM_STRING( g_rgwchDeviceRevocationLicenseTag );
const DRM_CONST_STRING      g_dstrWMDRMNETRevocationLicenseTag          = CREATE_DRM_STRING( g_rgwchWMDRMNETRevocationLicenseTag );

#if DRM_SUPPORT_REVOCATION

#if DRM_SUPPORT_WMDRMNET
const DRM_CONST_STRING      g_dstrRevocationGuidWMDRMNET                = CREATE_DRM_STRING( g_rgwchRevocationGuidWMDRMNET );
const DRM_ANSI_CONST_STRING g_dastrRevocationGuidWMDRMNET               = { g_rgchRevocationGuidWMDRMNET, 38 };
#endif /* DRM_SUPPORT_WMDRMNET */

#if DRM_SUPPORT_DEVICE_REVOCATION
const DRM_CONST_STRING      g_dstrRevocationGuidDevice                  = CREATE_DRM_STRING( g_rgwchRevocationGuidDevice   );
const DRM_ANSI_CONST_STRING g_dastrRevocationGuidDevice                 = { g_rgchRevocationGuidDevice  , 38 };
#endif /* DRM_SUPPORT_DEVICE_REVOCATION */

#if DRM_SUPPORT_APP_REVOCATION
const DRM_CONST_STRING      g_dstrRevocationGuidApp                     = CREATE_DRM_STRING( g_rgwchRevocationGuidApp      );
const DRM_ANSI_CONST_STRING g_dastrRevocationGuidApp                    = { g_rgchRevocationGuidApp     , 38 };
#endif /* DRM_SUPPORT_APP_REVOCATION */

#endif /*DRM_SUPPORT_REVOCATION */

const DRM_CONST_STRING      g_dstrPriority                              = CREATE_DRM_STRING( g_rgwchPriority );
const DRM_CONST_STRING      g_dstrIssueDate                             = CREATE_DRM_STRING( g_rgwchIssueDate );
const DRM_CONST_STRING      g_dstrContentPubKey                         = CREATE_DRM_STRING( g_rgwchContentPubKey );
const DRM_CONST_STRING      g_dstrContentRevocation                     = CREATE_DRM_STRING( g_rgwchContentRevocation );
const DRM_CONST_STRING      g_dstrCondition                             = CREATE_DRM_STRING( g_rgwchCondition );
const DRM_CONST_STRING      g_dstrAction                                = CREATE_DRM_STRING( g_rgwchAction );
const DRM_CONST_STRING      g_dstrRestrictions                          = CREATE_DRM_STRING( g_rgwchRestrictions );
const DRM_CONST_STRING      g_dstrChainedEnablingBits                   = CREATE_DRM_STRING( g_rgwchChainedEnablingBits );
const DRM_CONST_STRING      g_dstrDrmRestoreInfoEnablingBits            = CREATE_DRM_STRING( g_rgwchDrmRestoreInfoEnablingBits );
const DRM_CONST_STRING      g_dstrCertChain                             = CREATE_DRM_STRING( g_rgwchCertChain );
const DRM_CONST_STRING      g_dstrTagCertificate                        = CREATE_DRM_STRING( g_rgwchTagCertificate );
const DRM_CONST_STRING      g_dstrLISigHashAlgo                         = CREATE_DRM_STRING( g_rgwchLISigHashAlgo );
const DRM_CONST_STRING      g_dstrLISigAlgo                             = CREATE_DRM_STRING( g_rgwchLISigAlgo );
const DRM_CONST_STRING      g_dstrLISigValue                            = CREATE_DRM_STRING( g_rgwchLISigValue );
const DRM_CONST_STRING      g_dstrOnActionPath                          = CREATE_DRM_STRING( g_rgwchOnActionPath );
const DRM_CONST_STRING      g_dstrXPathSymSig                           = CREATE_DRM_STRING( g_rgwchXPathSymSig );
const DRM_CONST_STRING      g_dstrXPathSymValue                         = CREATE_DRM_STRING( g_rgwchXPathSymValue );

const DRM_CONST_STRING      g_dstrSequenceNumber                        = CREATE_DRM_STRING( g_rgwchSequenceNumber );
const DRM_CONST_STRING      g_dstrLSPubKey                              = CREATE_DRM_STRING( g_rgwchLSPubKey );
const DRM_CONST_STRING      g_dstrUplinkKid                             = CREATE_DRM_STRING( g_rgwchUplinkKid );
const DRM_CONST_STRING      g_dstrChainedCheckSum                       = CREATE_DRM_STRING( g_rgwchChainedCheckSum );
const DRM_CONST_STRING      g_dstrPMLicenseVersionString                = CREATE_DRM_STRING( g_rgwchPMLicenseVersionString );
const DRM_ANSI_CONST_STRING g_dastrPMLicenseVersionString               = { g_rgchPMLicenseVersionString, 7 }; /* Special case this odd length ANSI string */
const DRM_CONST_STRING      g_dstrRevAttribute                          = CREATE_DRM_STRING( g_rgwchRevAttribute );
const DRM_CONST_STRING      g_dstrDerivedLicTemplate                    = CREATE_DRM_STRING( g_rgwchDerivedLicTemplate );
const DRM_CONST_STRING      g_dstrLicDataDerivedTmpl                    = CREATE_DRM_STRING( g_rgwchLicDataDerivedTmpl );


/* XML tags used in writing Challenge and parsing Response for metering */
const DRM_CONST_STRING      g_dstrTagMetering                           = CREATE_DRM_STRING( g_rgwchTagMetering );
const DRM_CONST_STRING      g_dstrTagHash                               = CREATE_DRM_STRING( g_rgwchTagHash );
const DRM_CONST_STRING      g_dstrXPathMID                              = CREATE_DRM_STRING( g_rgwchXPathMID );                      
const DRM_CONST_STRING      g_dstrTagMID                                = CREATE_DRM_STRING( g_rgwchTagMID );                      
const DRM_CONST_STRING      g_dstrTagTID                                = CREATE_DRM_STRING( g_rgwchTagTID );
const DRM_CONST_STRING      g_dstrTagCmd                                = CREATE_DRM_STRING( g_rgwchTagCmd );
const DRM_CONST_STRING      g_dstrTagPassword                           = CREATE_DRM_STRING( g_rgwchTagPassword );
const DRM_CONST_STRING      g_dstrTagRecords                            = CREATE_DRM_STRING( g_rgwchTagRecords );
const DRM_CONST_STRING      g_dstrTagURL                                = CREATE_DRM_STRING( g_rgwchTagURL );
const DRM_CONST_STRING      g_dstrTagPartialData                        = CREATE_DRM_STRING( g_rgwchTagPartialData );
const DRM_CONST_STRING      g_dstrLabelValue                            = CREATE_DRM_STRING( g_rgwchLabelValue );
const DRM_CONST_STRING      g_dstrHMAC                                  = CREATE_DRM_STRING( g_rgwchHMAC );
const DRM_CONST_STRING      g_dstrChallenge                             = CREATE_DRM_STRING( g_rgwchChallenge );
const DRM_CONST_STRING      g_dstr1                                     = CREATE_DRM_STRING( g_rgwch1 );
const DRM_CONST_STRING      g_dstrReset                                 = CREATE_DRM_STRING( g_rgwchReset );

const DRM_ANSI_CONST_STRING g_dastrTagMeterCert                         = CREATE_DRM_ANSI_STRING( g_rgchTagMeterCert );

const DRM_CONST_STRING      g_dstrTagMeterCert                          = CREATE_DRM_STRING( g_rgwchTagMeterCert );

const DRM_CONST_STRING      g_dstrTagCertificateChain                   = CREATE_DRM_STRING( g_rgwchTagCertificateChain );

/* tags used for sync lists */
const DRM_CONST_STRING      g_dstrTagPrivateKey                         = CREATE_DRM_STRING( g_rgwchTagPrivateKey );
const DRM_CONST_STRING      g_dstrTagDevice                             = CREATE_DRM_STRING( g_rgwchTagDevice );
const DRM_CONST_STRING      g_dstrKeyDataTag                            = CREATE_DRM_STRING( g_rgwchKeyDataTag );
const DRM_CONST_STRING      g_dstrGroupTag                              = CREATE_DRM_STRING( g_rgwchGroupTag );

const DRM_CONST_STRING      g_dstrTagSyncList                           = CREATE_DRM_STRING( g_rgwchTagSyncList );
                                                                                                          
const DRM_CONST_STRING      g_dstrBackup                                = CREATE_DRM_STRING( g_rgwchBackup );
const DRM_CONST_STRING      g_dstrRestore                               = CREATE_DRM_STRING( g_rgwchRestore );
const DRM_CONST_STRING      g_dstrRootSigValueVersionTag                = CREATE_DRM_STRING( g_rgwchRootSigValueVersionTag );
const DRM_CONST_STRING      g_dstrRootSigValueVersionVal                = CREATE_DRM_STRING( g_rgwchRootSigValueVersionVal );
const DRM_CONST_STRING      g_dstrPFRootTag                             = CREATE_DRM_STRING( g_rgwchPFRootTag );
const DRM_CONST_STRING      g_dstrDACPubKeyTag                          = CREATE_DRM_STRING( g_rgwchDACPubKeyTag );
const DRM_CONST_STRING      g_dstrAuthRoot                              = CREATE_DRM_STRING( g_rgwchAuthRoot );
const DRM_CONST_STRING      g_dstrTagNameValue                          = CREATE_DRM_STRING( g_rgwchTagSecurityLevel );
const DRM_CONST_STRING      g_dstrTagSecurityLevel                      = CREATE_DRM_STRING( g_rgwchTagSecurityLevel );
const DRM_CONST_STRING      g_dstrTagDataId                             = CREATE_DRM_STRING( g_rgwchTagDataId );
const DRM_CONST_STRING      g_dstrTagDataPubKey                         = CREATE_DRM_STRING( g_rgwchTagDataPubKey );
const DRM_CONST_STRING      g_dstrFallBack                              = CREATE_DRM_STRING( g_rgwchFallBack );
const DRM_CONST_STRING      g_dstrTagName                               = CREATE_DRM_STRING( g_rgwchTagName );
const DRM_CONST_STRING      g_dstrManufacturer                          = CREATE_DRM_STRING( g_rgwchManufacturer );
const DRM_CONST_STRING      g_dstrModel                                 = CREATE_DRM_STRING( g_rgwchModel );
const DRM_CONST_STRING      g_dstrHwMajor                               = CREATE_DRM_STRING( g_rgwchHwMajor );
const DRM_CONST_STRING      g_dstrHwMinor                               = CREATE_DRM_STRING( g_rgwchHwMinor );
const DRM_CONST_STRING      g_dstrFwMajor                               = CREATE_DRM_STRING( g_rgwchFwMajor );
const DRM_CONST_STRING      g_dstrFwMinor                               = CREATE_DRM_STRING( g_rgwchFwMinor );
const DRM_CONST_STRING      g_dstrFeatures                              = CREATE_DRM_STRING( g_rgwchFeatures );
const DRM_CONST_STRING      g_dstrSecureClockNotSet                     = CREATE_DRM_STRING( g_rgwchSecClockNotSet );
const DRM_CONST_STRING      g_dstrSecureClockSet                        = CREATE_DRM_STRING( g_rgwchSecClockSet );
const DRM_CONST_STRING      g_dstrSecureClockNeedsRefresh               = CREATE_DRM_STRING( g_rgwchSecClockNeedsRefresh );
const DRM_CONST_STRING      g_dstrTemplate                              = CREATE_DRM_STRING( g_rgwchTemplate );
const DRM_CONST_STRING      g_dstrIndivPubKey                           = CREATE_DRM_STRING( g_rgwchIndivPubKey );
const DRM_CONST_STRING      g_dstrUniqueId                              = CREATE_DRM_STRING( g_rgwchUniqueId );
const DRM_CONST_STRING      g_dstrUnsignedtemplate                      = CREATE_DRM_STRING( g_rgwchUnsignedtemplate );

/* This data is used explicitly in the gen tools */
const DRM_CONST_STRING      g_dstrTagDataSecVer                         = CREATE_DRM_STRING( g_rgwchTagDataSecVer );

/* Strings for the expression evaluator functions */
const DRM_CONST_STRING      g_dstrExprFuncDateAdd                       = CREATE_DRM_STRING( g_rgwchExprFuncDateAdd );
const DRM_CONST_STRING      g_dstrExprFuncDateDiff                      = CREATE_DRM_STRING( g_rgwchExprFuncDateDiff );
const DRM_CONST_STRING      g_dstrExprFuncMin                           = CREATE_DRM_STRING( g_rgwchExprFuncMin );
const DRM_CONST_STRING      g_dstrExprFuncMax                           = CREATE_DRM_STRING( g_rgwchExprFuncMax );
const DRM_CONST_STRING      g_dstrExprFuncDatePart                      = CREATE_DRM_STRING( g_rgwchExprFuncDatePart );
const DRM_CONST_STRING      g_dstrExprFuncVersionCompare                = CREATE_DRM_STRING( g_rgwchExprFuncVersionCompare );
const DRM_CONST_STRING      g_dstrExprFuncDeleteLicense                 = CREATE_DRM_STRING( g_rgwchExprFuncDeleteLicense );
const DRM_CONST_STRING      g_dstrExprFuncExists                        = CREATE_DRM_STRING( g_rgwchExprFuncExists );

/* Strings for license evaluator well known actions */
const DRM_CONST_STRING      g_dstrLicEvalOnSelect                       = CREATE_DRM_STRING( g_rgwchLicEvalOnSelect );
const DRM_CONST_STRING      g_dstrLicEvalOnDelete                       = CREATE_DRM_STRING( g_rgwchLicEvalOnDelete );
const DRM_CONST_STRING      g_dstrLicEvalOnStore                        = CREATE_DRM_STRING( g_rgwchLicEvalOnStore );
const DRM_CONST_STRING      g_dstrLicEvalOnAction                       = CREATE_DRM_STRING( g_rgwchLicEvalOnAction );
#if DRM_SUPPORT_ANTIROLLBACK_CLOCK 
const DRM_CONST_STRING      g_dstrLicEvalOnClockRollback                = CREATE_DRM_STRING( g_rgwchLicEvalOnClockRollback );
#endif

/* Strings for expression evaluator variable evaluation */
const DRM_CONST_STRING      g_dstrDRM_PREFIX                            = CREATE_DRM_STRING( g_rgwchDRM_PREFIX );
const DRM_CONST_STRING      g_dstrDRMK_PREFIX                           = CREATE_DRM_STRING( g_rgwchDRMK_PREFIX );
const DRM_CONST_STRING      g_dstrMACHINE_PREFIX                        = CREATE_DRM_STRING( g_rgwchMACHINE_PREFIX );
const DRM_CONST_STRING      g_dstrAPP_PREFIX                            = CREATE_DRM_STRING( g_rgwchAPP_PREFIX );
const DRM_CONST_STRING      g_dstrSECSTATE_PREFIX                       = CREATE_DRM_STRING( g_rgwchSECSTATE_PREFIX );
const DRM_CONST_STRING      g_dstrLICENSE_PREFIX                        = CREATE_DRM_STRING( g_rgwchLICENSE_PREFIX );
const DRM_CONST_STRING      g_dstrCONTENT_PREFIX                        = CREATE_DRM_STRING( g_rgwchCONTENT_PREFIX );
const DRM_CONST_STRING      g_dstrDEVICE_PREFIX                         = CREATE_DRM_STRING( g_rgwchDEVICE_PREFIX );
const DRM_CONST_STRING      g_dstrPMLICENSE_PREFIX                      = CREATE_DRM_STRING( g_rgwchPMLICENSE_PREFIX );
const DRM_CONST_STRING      g_dstrSECURETIME_PREFIX                     = CREATE_DRM_STRING( g_rgwchSECURETIME_PREFIX );
const DRM_CONST_STRING      g_dstrPLAYLISTBURN_PREFIX                   = CREATE_DRM_STRING( g_rgwchPLAYLISTBURN_PREFIX );

#if DRM_SUPPORT_SST_REDUNANCY
const DRM_CONST_STRING      g_dstrSSTREDUNDANCY_PREFIX                  = CREATE_DRM_STRING( g_rgwchSSTREDUNDANCY_PREFIX );
#endif

const DRM_CONST_STRING      g_dstrExprVarVersion                        = CREATE_DRM_STRING( g_rgwchExprVarVersion );
const DRM_CONST_STRING      g_dstrExprVarParameter                      = CREATE_DRM_STRING( g_rgwchExprVarParameter );
const DRM_CONST_STRING      g_dstrExprVarReason                         = CREATE_DRM_STRING( g_rgwchExprVarReason );
const DRM_CONST_STRING      g_dstrExprVarBBMSDRMVersion                 = CREATE_DRM_STRING( g_rgwchExprVarBBMSDRMVersion );
const DRM_CONST_STRING      g_dstrExprVarDateTime                       = CREATE_DRM_STRING( g_rgwchExprVarDateTime );
const DRM_CONST_STRING      g_dstrExprVarCount                          = CREATE_DRM_STRING( g_rgwchExprVarCount );
const DRM_CONST_STRING      g_dstrExprVarMinSecLevel                    = CREATE_DRM_STRING( g_rgwchExprVarMinSecLevel );
const DRM_CONST_STRING      g_dstrExprVarSecLevel                       = CREATE_DRM_STRING( g_rgwchExprVarSecLevel );
const DRM_CONST_STRING      g_dstrExprVarAppSecLevel                    = CREATE_DRM_STRING( g_rgwchExprVarAppSecLevel );
const DRM_CONST_STRING      g_dstrExprVarSubjID                         = CREATE_DRM_STRING( g_rgwchExprVarSubjID );
const DRM_CONST_STRING      g_dstrExprVarAppSubjID                      = CREATE_DRM_STRING( g_rgwchExprVarAppSubjID );
const DRM_CONST_STRING      g_dstrExprVarGlobal                         = CREATE_DRM_STRING( g_rgwchExprVarGlobal );
const DRM_CONST_STRING      g_dstrExprVarSaveDateTime                   = CREATE_DRM_STRING( g_rgwchExprVarSaveDateTime );
const DRM_CONST_STRING      g_dstrExprVarSavedDateTime                  = CREATE_DRM_STRING( g_rgwchExprVarSavedDateTime );
const DRM_CONST_STRING      g_dstrExprVarDRMReason                      = CREATE_DRM_STRING( g_rgwchExprVarDRMReason );
const DRM_CONST_STRING      g_dstrExprVarRights                         = CREATE_DRM_STRING( g_rgwchExprVarRights );
const DRM_CONST_STRING      g_dstrExprVarExpiryDate                     = CREATE_DRM_STRING( g_rgwchExprVarExpiryDate );
const DRM_CONST_STRING      g_dstrExprVarInGracePeriod                  = CREATE_DRM_STRING( g_rgwchExprVarInGracePeriod );
const DRM_CONST_STRING      g_dstrExprVarGpStartTime                    = CREATE_DRM_STRING( g_rgwchExprVarGpStartTime );
const DRM_CONST_STRING      g_dstrExprVarIncrementCount                 = CREATE_DRM_STRING( g_rgwchExprVarIncrementCount );
const DRM_CONST_STRING      g_dstrExprVarDevReg                         = CREATE_DRM_STRING( g_rgwchExprVarDevReg );

/* XML tags */
const DRM_CONST_STRING      g_dstrTagCDATA                              = CREATE_DRM_STRING( g_rgwchTagCDATA );
const DRM_CONST_STRING      g_dstrTagCDATAOpenBracket                   = CREATE_DRM_STRING( g_rgwchTagCDATAOpenBracket );
const DRM_ANSI_CONST_STRING g_dastrTagCDATAOpenBracket                  = CREATE_DRM_ANSI_STRING( g_rgchTagCDATAOpenBracket );
const DRM_CONST_STRING      g_dstrOpenTag                               = CREATE_DRM_STRING( g_rgwchOpenTag );
const DRM_CONST_STRING      g_dstrSpace                                 = CREATE_DRM_STRING( g_rgwchSpace );
const DRM_CONST_STRING      g_dstrOpenEndTag                            = CREATE_DRM_STRING( g_rgwchOpenEndTag );
const DRM_CONST_STRING      g_dstrCloseTag                              = CREATE_DRM_STRING( g_rgwchCloseTag );
const DRM_CONST_STRING      g_dstrEqualQuote                            = CREATE_DRM_STRING( g_rgwchEqualQuote );
const DRM_CONST_STRING      g_dstrQuote                                 = CREATE_DRM_STRING( g_rgwchQuote );
const DRM_CONST_STRING      g_dstrOpenCDATATag                          = CREATE_DRM_STRING( g_rgwchOpenCDATATag );
const DRM_CONST_STRING      g_dstrCloseCDATATag                         = CREATE_DRM_STRING( g_rgwchCloseCDATATag );


const DRM_ANSI_CONST_STRING  g_dastrAttributeAlgorithm                  = { g_rgchAttributeAlgorithm, g_rgchAttributeAlgorithm_LEN };
const DRM_ANSI_CONST_STRING  g_dastrAttributeVersionWMDRM               = { g_rgchAttributeVersionWMDRM, g_rgchAttributeVersionWMDRM_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagEscrowedKeys                     = { g_rgchTagEscrowedKeys, g_rgchTagEscrowedKeys_LEN };
const DRM_ANSI_CONST_STRING  g_dastrKeyUsageSignCert                    = { g_rgchKeyUsageSignCert, g_rgchKeyUsageSignCert_LEN };
const DRM_ANSI_CONST_STRING  g_dastrKeyUsageSignCRL                     = { g_rgchKeyUsageSignCRL, g_rgchKeyUsageSignCRL_LEN };
const DRM_ANSI_CONST_STRING  g_dastrKeyUsageEncryptKey                  = { g_rgchKeyUsageEncryptKey, g_rgchKeyUsageEncryptKey_LEN };
const DRM_ANSI_CONST_STRING  g_dastrOne                                 = { g_rgchOne, g_rgchOne_LEN };
const DRM_ANSI_CONST_STRING  g_dastrPrefixManufacturer                  = { g_rgchPrefixManufacturer, g_rgchPrefixManufacturer_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagCanonicalization                 = { g_rgchTagCanonicalization, g_rgchTagCanonicalization_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagCertificateCollection            = { g_rgchTagCertificateCollection, g_rgchTagCertificateCollection_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagDigestMethod                     = { g_rgchTagDigestMethod, g_rgchTagDigestMethod_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURIDSigSHA1                         = { g_rgchURIDSigSHA1, g_rgchURIDSigSHA1_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagDigestValue                      = { g_rgchTagDigestValue, g_rgchTagDigestValue_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagSignatureValue                   = { g_rgchTagSignatureValue, g_rgchTagSignatureValue_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagKeyInfo                          = { g_rgchTagKeyInfo, g_rgchTagKeyInfo_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagSymmetricKey                     = { g_rgchTagSymmetricKey, g_rgchTagSymmetricKey_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagPublicKey                        = { g_rgchTagPublicKey, g_rgchTagPublicKey_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagPrivateKey                       = { g_rgchTagPrivateKey, g_rgchTagPrivateKey_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagKeyValue                         = { g_rgchTagKeyValue, g_rgchTagKeyValue_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagRSAKeyValue                      = { g_rgchTagRSAKeyValue, g_rgchTagRSAKeyValue_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagModulus                          = { g_rgchTagModulus, g_rgchTagModulus_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagExponent                         = { g_rgchTagExponent, g_rgchTagExponent_LEN };

const DRM_ANSI_CONST_STRING  g_dastrTagManufacturerName                 = { g_rgchTagManufacturerName, g_rgchTagManufacturerName_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagManufacturerData                 = { g_rgchTagManufacturerData, g_rgchTagManufacturerData_LEN }; 
const DRM_ANSI_CONST_STRING  g_dastrTagModelName                        = { g_rgchTagModelName, g_rgchTagModelName_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagModelNumber                      = { g_rgchTagModelNumber, g_rgchTagModelNumber_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagHardwareID                         = { g_rgchTagHardwareID, g_rgchTagHardwareID_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURIRSASHA1                          = { g_rgchURIRSASHA1, g_rgchURIRSASHA1_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURIRSASHA1_Old                      = { g_rgchURIRSASHA1_Old, g_rgchURIRSASHA1_Old_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagReference                        = { g_rgchTagReference, g_rgchTagReference_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagTransforms                       = { g_rgchTagTransforms, g_rgchTagTransforms_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagTransform                        = { g_rgchTagTransform, g_rgchTagTransform_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURITransformMSCert                  = { g_rgchURITransformMSCert, g_rgchURITransformMSCert_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURITransformMSCertColl              = { g_rgchURITransformMSCertColl, g_rgchURITransformMSCertColl_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURITransformMSCert_Old              = { g_rgchURITransformMSCert_Old, g_rgchURITransformMSCert_Old_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURITransformC14N                    = { g_rgchURITransformC14N, g_rgchURITransformC14N_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMCertificate                 = { g_rgchTagWMDRMCertificate, g_rgchTagWMDRMCertificate_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMData                        = { g_rgchTagDataWMDRM, g_rgchTagDataWMDRM_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMCertPublicKey               = { g_rgchTagWMDRMCertPublicKey, g_rgchTagWMDRMCertPublicKey_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMCertSecurityVersion         = { g_rgchTagWMDRMCertSecurityVersion, g_rgchTagWMDRMCertSecurityVersion_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMCertSecurityLevel           = { g_rgchTagWMDRMCertSecurityLevel, g_rgchTagWMDRMCertSecurityLevel_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMCertSerialNumber            = { g_rgchTagWMDRMCertSerialNumber, g_rgchTagWMDRMCertSerialNumber_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMCertFeatures                = { g_rgchTagWMDRMCertFeatures, g_rgchTagWMDRMCertFeatures_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagWMDRMCertKeyUsage                = { g_rgchTagWMDRMCertKeyUsage, g_rgchTagWMDRMCertKeyUsage_LEN };

const DRM_ANSI_CONST_STRING  g_dastrTagSignature                        = { g_rgchTagSignature, g_rgchTagSignature_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagSignatureMethod                  = { g_rgchTagSignatureMethod, g_rgchTagSignatureMethod_LEN };
const DRM_ANSI_CONST_STRING  g_dastrTagSignedInfo                       = { g_rgchTagSignedInfo, g_rgchTagSignedInfo_LEN };
const DRM_ANSI_CONST_STRING  g_dastrURIC14N                             = { g_rgchURIC14N, g_rgchURIC14N_LEN };
const DRM_ANSI_CONST_STRING  g_dastrVersionWMDRM                        = { g_rgchVersionWMDRM, g_rgchVersionWMDRM_LEN };
const DRM_ANSI_CONST_STRING  g_dastrWMDRMCertExponent                   = { g_rgchWMDRMCertExponent, g_rgchWMDRMCertExponent_LEN };


const DRM_ANSI_CONST_STRING  g_dastrFeatureSampleProtection             = { g_rgchFeatureSampleProtection, g_rgchFeatureSampleProtection_LEN };
const DRM_ANSI_CONST_STRING  g_dastrFeatureExport                       = { g_rgchFeatureExport, g_rgchFeatureExport_LEN };
const DRM_ANSI_CONST_STRING  g_dastrFeatureExportIncl                   = { g_rgchFeatureExportIncl, g_rgchFeatureExportIncl_LEN};

const DRM_ANSI_CONST_STRING  g_dastrPrefixMicrosoftCert                 = { g_rgchPrefixMicrosoftCert, g_rgchPrefixMicrosoftCert_LEN };

const DRM_ANSI_CONST_STRING  g_dastrMSRootPubKey                        = { g_rgchMSRootPubKey, g_rgchMSRootPubKey_LEN };

/* Secure clock Challenge\response XML tags */
const DRM_CONST_STRING      g_dstrTagDRMReqRoot                         = CREATE_DRM_STRING( g_rgwchTagDRMReqRoot );
const DRM_CONST_STRING      g_dstrResponse                              = CREATE_DRM_STRING( g_rgwchResponse );
const DRM_CONST_STRING      g_dstrStatus                                = CREATE_DRM_STRING( g_rgwchStatus );
const DRM_CONST_STRING      g_dstrFlag                                  = CREATE_DRM_STRING( g_rgwchFlag );
const DRM_CONST_STRING      g_dstrTagGmtTime                            = CREATE_DRM_STRING( g_rgwchTagGmtTime );
const DRM_CONST_STRING      g_dstrTagRefreshDate                        = CREATE_DRM_STRING( g_rgwchTagRefreshDate );

/* Output Level strings */
const DRM_CONST_STRING      g_dstrLabelGuid                             = CREATE_DRM_STRING( g_rgwchLabelGuid );
const DRM_CONST_STRING      g_dstrLabelLevel                            = CREATE_DRM_STRING( g_rgwchLabelLevel );
const DRM_CONST_STRING      g_dstrTagUncompressedDigitalVideo           = CREATE_DRM_STRING( g_rgwchTagUncompressedDigitalVideo );
const DRM_CONST_STRING      g_dstrTagCompressedDigitalVideo             = CREATE_DRM_STRING( g_rgwchTagCompressedDigitalVideo );
const DRM_CONST_STRING      g_dstrTagUncompressedDigitalAudio           = CREATE_DRM_STRING( g_rgwchTagUncompressedDigitalAudio );
const DRM_CONST_STRING      g_dstrTagCompressedDigitalAudio             = CREATE_DRM_STRING( g_rgwchTagCompressedDigitalAudio );
const DRM_CONST_STRING      g_dstrTagAnalogVideo                        = CREATE_DRM_STRING( g_rgwchTagAnalogVideo );
const DRM_CONST_STRING      g_dstrTagCopy                               = CREATE_DRM_STRING( g_rgwchTagCopy );
const DRM_CONST_STRING      g_dstrTagExtensionList                      = CREATE_DRM_STRING( g_rgwchTagExtensionList );
const DRM_CONST_STRING      g_dstrTagExtension                          = CREATE_DRM_STRING( g_rgwchTagExtension );
const DRM_CONST_STRING      g_dstrTagIncludeList                        = CREATE_DRM_STRING( g_rgwchTagIncludeList );
const DRM_CONST_STRING      g_dstrTagInclude                            = CREATE_DRM_STRING( g_rgwchTagInclude );
const DRM_CONST_STRING      g_dstrTagExcludeList                        = CREATE_DRM_STRING( g_rgwchTagExcludeList );
const DRM_CONST_STRING      g_dstrTagExclude                            = CREATE_DRM_STRING( g_rgwchTagExclude );

const DRM_CONST_STRING      g_dstrMSRootPubKey                          = CREATE_DRM_STRING( g_rgwchMSRootPubKey );


/* License State strings */
const DRM_CONST_STRING      g_dstrTagLicenseStateRequestRoot            = CREATE_DRM_STRING( g_rgwchTagLicenseStateRequestRoot );
const DRM_CONST_STRING      g_dstrTagCanBind                            = CREATE_DRM_STRING( g_rgwchTagCanBind );


/*Device License Revocation Blob Strings*/

const DRM_CONST_STRING      g_dstrTagDeviceLicenseRevocationRoot        = CREATE_DRM_STRING( g_rgwchTagDeviceLicenseRevocationRoot );
const DRM_CONST_STRING      g_dstrTagRevocationPubKey                   = CREATE_DRM_STRING( g_rgwchTagRevocationPubKey );


#if DRM_SUPPORT_REVOCATION
/* Revocation GUIDs */

const DRM_GUID g_guidRevocationTypeRevInfo = {
    0xCCDE5A55, 
    0xA688, 
    0x4405, 
    { 
        TWO_BYTES( 0xA8, 0x8B ), TWO_BYTES( 0xD1, 0x3F ),
        TWO_BYTES( 0x90, 0xD5 ), TWO_BYTES( 0xBA, 0x3E )
    }
};

#if DRM_SUPPORT_WMDRMNET
const DRM_GUID g_guidRevocationTypeWMDRMNET = {
    0xCD75E604, 
    0x543D, 
    0x4A9C, 
    { 
        TWO_BYTES( 0x9F, 0x09 ), TWO_BYTES( 0xFE, 0x6D ),
        TWO_BYTES( 0x24, 0xE8 ), TWO_BYTES( 0xBF, 0x90 )
    }
};
#endif /* DRM_SUPPORT_WMDRMNET */ 

#if DRM_SUPPORT_DEVICE_REVOCATION
const DRM_GUID g_guidRevocationTypeDevice = {
    0x3129E375, 
    0xCEB0, 
    0x47D5, 
    { 
        TWO_BYTES( 0x9C, 0xCA ), TWO_BYTES( 0x9D, 0xB7 ),
        TWO_BYTES( 0x4C, 0xFD ), TWO_BYTES( 0x43, 0x32 )
    }
};
#endif /* DRM_SUPPORT_DEVICE_REVOCATION */

#if DRM_SUPPORT_APP_REVOCATION
const DRM_GUID g_guidRevocationTypeApp = {
    0x90A37313, 
    0x0ECF, 0x4CAA, 
    {
        TWO_BYTES( 0xA9, 0x06 ), TWO_BYTES( 0xB1, 0x88 ),
        TWO_BYTES( 0xF6, 0x12 ), TWO_BYTES( 0x93, 0x00 )
    }
};
#endif /* DRM_SUPPORT_APP_REVOCATION */

#endif /* DRM_SUPPORT_REVOCATION */

#endif
